/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.core.IArmorNaturalist;
import forestry.api.core.Tabs;
import forestry.core.config.Defaults;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemArmorApiarist
extends ItemArmor
implements IArmorApiarist,
IArmorNaturalist {
    public ItemArmorApiarist(int slot) {
        super(ItemArmor.ArmorMaterial.CLOTH, 0, slot);
        this.setMaxDamage(100);
        this.setCreativeTab(Tabs.tabApiculture);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (ForestryItem.apiaristLegs.isItemEqual(stack)) {
            return Defaults.ID + ":" + "textures/items/apiarist_armor_2.png";
        }
        return Defaults.ID + ":" + "textures/items/apiarist_armor_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = TextureManager.getInstance().registerTex(register, StringUtil.cleanItemName((Item)this));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int par1, int par2) {
        return this.itemIcon;
    }

    public boolean requiresMultipleRenderPasses() {
        return false;
    }

    public int getColorFromItemStack(ItemStack itemstack, int renderPass) {
        return 0xFFFFFF;
    }

    public boolean hasColor(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean protectPlayer(EntityPlayer player, ItemStack armor, String cause, boolean doProtect) {
        return true;
    }

    @Override
    public boolean canSeePollination(EntityPlayer player, ItemStack armor, boolean doSee) {
        return this.armorType == 0;
    }

    private static boolean isArmorApiarist(ItemStack itemStack, EntityPlayer player, String cause, boolean protect) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof IArmorApiarist)) {
            return false;
        }
        return ((IArmorApiarist)item).protectPlayer(player, itemStack, cause, protect);
    }

    public static int wearsItems(EntityPlayer player, String cause, boolean protect) {
        int count = 0;
        for (ItemStack armorItem : player.inventory.armorInventory) {
            if (!ItemArmorApiarist.isArmorApiarist(armorItem, player, cause, protect)) continue;
            ++count;
        }
        return count;
    }
}

