/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.IModelManager;
import forestry.api.mail.ILetter;
import forestry.mail.PluginMail;
import forestry.mail.items.ItemLetter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LetterProperties {
    @SideOnly(value=Side.CLIENT)
    private static ModelResourceLocation[][] models;

    public static ItemStack createStampedLetterStack(ILetter letter) {
        Size size = LetterProperties.getSize(letter);
        int meta = LetterProperties.encodeMeta(State.STAMPED, size);
        return new ItemStack((Item)PluginMail.getItems().letters, 1, meta);
    }

    public static void closeLetter(ItemStack parent, ILetter letter) {
        State state = LetterProperties.getState(parent.func_77952_i());
        Size size = LetterProperties.getSize(parent.func_77952_i());
        switch (state) {
            case OPENED: {
                if (letter.countAttachments() > 0) break;
                state = State.EMPTIED;
                break;
            }
            case FRESH: 
            case STAMPED: {
                state = letter.isMailable() && letter.isPostPaid() ? State.STAMPED : State.FRESH;
                size = LetterProperties.getSize(letter);
                break;
            }
        }
        int meta = LetterProperties.encodeMeta(state, size);
        parent.func_77964_b(meta);
        letter.writeToNBT(parent.func_77978_p());
    }

    public static void openLetter(ItemStack parent) {
        int oldMeta = parent.func_77952_i();
        State state = LetterProperties.getState(oldMeta);
        if (state == State.FRESH || state == State.STAMPED) {
            Size size = LetterProperties.getSize(oldMeta);
            int newMeta = LetterProperties.encodeMeta(State.OPENED, size);
            parent.func_77964_b(newMeta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, IModelManager manager) {
        models = new ModelResourceLocation[3][4];
        for (int i = 0; i < 3; ++i) {
            LetterProperties.models[i][0] = new ModelResourceLocation("forestry:mail/letter." + i + ".fresh", "inventory");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:mail/letter." + i + ".fresh")});
            LetterProperties.models[i][1] = new ModelResourceLocation("forestry:mail/letter." + i + ".stamped", "inventory");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:mail/letter." + i + ".stamped")});
            LetterProperties.models[i][2] = new ModelResourceLocation("forestry:mail/letter." + i + ".opened", "inventory");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:mail/letter." + i + ".opened")});
            LetterProperties.models[i][3] = new ModelResourceLocation("forestry:mail/letter." + i + ".emptied", "inventory");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:mail/letter." + i + ".emptied")});
        }
        manager.registerItemModel(item, new LetterMeshDefinition());
    }

    public static void getSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        int meta = LetterProperties.encodeMeta(State.FRESH, Size.EMPTY);
        ItemStack letter = new ItemStack(item, 1, meta);
        list.add(letter);
    }

    public static List<ItemStack> getEmptiedLetters(ItemLetter item) {
        ArrayList<ItemStack> openedLetters = new ArrayList<ItemStack>();
        for (Size size : Size.values()) {
            int meta = LetterProperties.encodeMeta(State.EMPTIED, size);
            ItemStack letter = new ItemStack((Item)item, 1, meta);
            openedLetters.add(letter);
        }
        return openedLetters;
    }

    private static State getState(int meta) {
        int ordinal = meta & 0xF;
        State[] values = State.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static Size getSize(int meta) {
        int ordinal = meta >> 4;
        Size[] values = Size.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static int encodeMeta(State state, Size size) {
        int meta = size.ordinal() << 4;
        return meta |= state.ordinal();
    }

    private static Size getSize(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return Size.BIG;
        }
        if (count > 1) {
            return Size.SMALL;
        }
        return Size.EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    private static class LetterMeshDefinition
    implements ItemMeshDefinition {
        private LetterMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            int damage = stack.func_77952_i();
            State state = LetterProperties.getState(damage);
            Size size = LetterProperties.getSize(damage);
            return models[size.ordinal()][state.ordinal()];
        }
    }

    private static enum Size {
        EMPTY,
        SMALL,
        BIG;

    }

    private static enum State {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;

    }
}

