/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.core.climate.ClimateInfo;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.owner.IOwnedTile;
import forestry.greenhouse.gui.ClimateTextFields;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.GreenhouseEnergyLedger;
import forestry.greenhouse.gui.WidgetCamouflageTab;
import forestry.greenhouse.gui.WidgetClimatePillar;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGreenhouse
extends GuiForestryTitled<ContainerGreenhouse> {
    private final IGreenhouseControllerInternal controller;
    private final IOwnedTile tile;
    private ClimateTextFields fields;

    public GuiGreenhouse(EntityPlayer player, TileGreenhouse tile) {
        super("textures/gui/greenhouse.png", new ContainerGreenhouse(player.field_71071_by, tile), tile);
        this.controller = ((MultiblockLogicGreenhouse)tile.getMultiblockLogic()).getController();
        this.tile = tile;
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 16, 0).setOverlayOrigin(176, 0));
        int x = 3;
        WidgetCamouflageTab previous = new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + x, this.field_147009_r - 25, this.controller, tile, "block");
        this.widgetManager.add(previous);
        previous = new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + (x += 50 + (previous.getHandlerSlot() != null ? 20 : 0)), this.field_147009_r - 25, this.controller, tile, "glass");
        this.widgetManager.add(previous);
        this.widgetManager.add(new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + (x += 50 + (previous.getHandlerSlot() != null ? 20 : 0)), this.field_147009_r - 25, this.controller, tile, "door"));
        if (this.hasFields()) {
            this.widgetManager.add(new WidgetClimatePillar(this.widgetManager, this.field_147003_i - 23, this.field_147009_r + 5));
        }
    }

    public boolean hasFields() {
        return this.controller != null && this.controller.getControlClimate() != ClimateInfo.MAX;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.fields = this.hasFields() ? new ClimateTextFields(this.controller, this.field_146289_q, this.field_147003_i, this.field_147009_r) : null;
    }

    public ClimateTextFields getFields() {
        return this.fields;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.fields == null || !this.fields.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.fields != null) {
            this.fields.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        if (this.fields != null) {
            this.fields.draw(this, mouseX, mouseY);
        }
    }

    TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.controller);
        this.ledgerManager.add(new GreenhouseEnergyLedger(this.ledgerManager, this.controller));
        this.addClimateLedger(this.controller);
        this.addHintLedger("greenhouse");
        this.addOwnerLedger(this.tile);
    }
}

