/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.core.tiles.TileUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import java.util.EnumMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum BlockGreenhouseType {
    PLAIN,
    GLASS(Material.field_151592_s),
    HATCH_INPUT(true),
    HATCH_OUTPUT(true),
    GEARBOX(true),
    VALVE(true),
    HEATER(true, true),
    FAN(true, true),
    HUMIDIFIER(true, true),
    DEHUMIDIFIER(true, true),
    WINDOW(Material.field_151592_s, false, true),
    WINDOW_UP(Material.field_151592_s, false, true),
    CONTROL(true),
    DOOR,
    CLIMATE_CONTROL(true),
    NURSERY(true);

    public static final BlockGreenhouseType[] VALUES;
    public final boolean hasOverlaySprite;
    public final boolean activatable;
    public final Material material;
    @SideOnly(value=Side.CLIENT)
    private static EnumMap<BlockGreenhouseSprites, TextureAtlasSprite> sprites;

    private BlockGreenhouseType(Material material, boolean hasOverlaySprite, boolean activatable) {
        this.hasOverlaySprite = hasOverlaySprite;
        this.activatable = activatable;
        this.material = material;
    }

    private BlockGreenhouseType(Material material, boolean hasOverlaySprite) {
        this(material, hasOverlaySprite, false);
    }

    private BlockGreenhouseType(Material material) {
        this(material, false, false);
    }

    private BlockGreenhouseType(boolean hasOverlaySprite, boolean activatable) {
        this(Material.field_151576_e, hasOverlaySprite, activatable);
    }

    private BlockGreenhouseType(boolean hasOverlaySprite) {
        this(Material.field_151576_e, hasOverlaySprite);
    }

    private BlockGreenhouseType() {
        this(Material.field_151576_e);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerSprites() {
        sprites = new EnumMap(BlockGreenhouseSprites.class);
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (BlockGreenhouseSprites sprite : BlockGreenhouseSprites.VALUES) {
            ResourceLocation location = new ResourceLocation("forestry", "blocks/greenhouse/" + sprite.spriteName);
            TextureAtlasSprite textureAtlasSprite = map.func_174942_a(location);
            sprites.put(sprite, textureAtlasSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(BlockGreenhouseType type, @Nullable EnumFacing facing, @Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        TileEntity tile = null;
        if (world != null && pos != null) {
            tile = TileUtil.getTile(world, pos);
        }
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        switch (type) {
            case PLAIN: {
                return map.func_110572_b("minecraft:blocks/brick");
            }
            case GLASS: {
                return map.func_110572_b("minecraft:blocks/glass_green");
            }
            case GEARBOX: {
                return sprites.get((Object)BlockGreenhouseSprites.GEARS);
            }
            case VALVE: {
                return sprites.get((Object)BlockGreenhouseSprites.VALVE);
            }
            case HEATER: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.HEATER_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.HEATER_ON);
            }
            case FAN: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.FAN_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.FAN_ON);
            }
            case HUMIDIFIER: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.HUMIDIFIER_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.HUMIDIFIER_ON);
            }
            case DEHUMIDIFIER: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.DEHUMIDIFIER_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.DEHUMIDIFIER_ON);
            }
            case CONTROL: {
                return sprites.get((Object)BlockGreenhouseSprites.CONTROL);
            }
            case HATCH_OUTPUT: 
            case HATCH_INPUT: {
                if (tile == null || facing == null || !(tile instanceof TileGreenhouseHatch)) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_DEFAULT);
                }
                TileGreenhouseHatch hatch = (TileGreenhouseHatch)tile;
                if (hatch.getOutwardsDir() == null) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_DEFAULT);
                }
                if (hatch.getOutwardsDir() == facing) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_OUTPUT);
                }
                if (hatch.getOutwardsDir().func_176734_d() == facing) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_INPUT);
                }
                return Minecraft.func_71410_x().func_147117_R().field_94249_f;
            }
            case CLIMATE_CONTROL: {
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    return Minecraft.func_71410_x().func_147117_R().field_94249_f;
                }
                return sprites.get((Object)BlockGreenhouseSprites.CLIMATE_CONTROL);
            }
            case NURSERY: {
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    return Minecraft.func_71410_x().func_147117_R().field_94249_f;
                }
                return sprites.get((Object)BlockGreenhouseSprites.BUTTERFLY_HATCH);
            }
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumMap<BlockGreenhouseSprites, TextureAtlasSprite> getSprites() {
        return sprites;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = BlockGreenhouseType.values();
    }

    private static enum BlockGreenhouseSprites {
        GEARS("gears"),
        VALVE("valve"),
        HEATER_OFF("heater.off"),
        HEATER_ON("heater.on"),
        FAN_OFF("fan.off"),
        FAN_ON("fan.on"),
        HUMIDIFIER_OFF("humidifier.off"),
        HUMIDIFIER_ON("humidifier.on"),
        DEHUMIDIFIER_OFF("dehumidifier.off"),
        DEHUMIDIFIER_ON("dehumidifier.on"),
        CONTROL("control"),
        HATCH_DEFAULT("hatch"),
        HATCH_INPUT("hatch_input"),
        HATCH_OUTPUT("hatch_output"),
        CLIMATE_CONTROL("climate_control"),
        BUTTERFLY_HATCH("butterfly_hatch");

        public static final BlockGreenhouseSprites[] VALUES;
        private final String spriteName;

        private BlockGreenhouseSprites(String spriteName) {
            this.spriteName = spriteName;
        }

        static {
            VALUES = BlockGreenhouseSprites.values();
        }
    }
}

