/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.api.core.IErrorLogicSource;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.render.TextureManagerForestry;
import forestry.core.tiles.ITitled;
import forestry.core.tiles.TileEngine;
import forestry.core.utils.Translator;
import net.minecraft.inventory.Container;

public abstract class GuiEngine<C extends Container, I extends TileEngine>
extends GuiForestryTitled<C> {
    protected final I tile;

    protected GuiEngine(String texture, C container, I tile) {
        super(texture, container, (ITitled)tile);
        this.tile = tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.ledgerManager.insert(new EngineLedger());
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger((IErrorLogicSource)this.tile);
        this.addHintLedger(((TileEngine)this.tile).getHintKey());
        this.ledgerManager.add(new EngineLedger());
    }

    protected class EngineLedger
    extends Ledger {
        public EngineLedger() {
            super(GuiEngine.this.ledgerManager, "power");
            this.maxHeight = 94;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawSprite(TextureManagerForestry.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
            this.drawSubheader(Translator.translateToLocal("for.gui.currentOutput") + ':', x + 22, y + 20);
            this.drawText(((TileEngine)GuiEngine.this.tile).getCurrentOutput() + " RF/t", x + 22, y + 32);
            this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 44);
            this.drawText(((TileEngine)GuiEngine.this.tile).getEnergyManager().getEnergyStored() + " RF", x + 22, y + 56);
            this.drawSubheader(Translator.translateToLocal("for.gui.heat") + ':', x + 22, y + 68);
            this.drawText((double)((TileEngine)GuiEngine.this.tile).getHeat() / 10.0 + 20.0 + " C", x + 22, y + 80);
        }

        @Override
        public String getTooltip() {
            return ((TileEngine)GuiEngine.this.tile).getCurrentOutput() + " RF/t";
        }
    }
}

