/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.models.ModelManager;
import forestry.core.models.baker.ModelBakerFace;
import forestry.core.models.baker.ModelBakerModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public final class ModelBaker
implements IModelBaker {
    private static final float[] UVS = new float[]{16.0f, 16.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0f};
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Vector3f POS_FROM = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f POS_TO = new Vector3f(16.0f, 16.0f, 16.0f);
    private final List<ModelBakerFace> faces = new ArrayList<ModelBakerFace>();
    private final List<Pair<IBlockState, IBakedModel>> bakedModels = new ArrayList<Pair<IBlockState, IBakedModel>>();
    protected final ModelBakerModel currentModel = new ModelBakerModel(ModelManager.getInstance().getDefaultBlockState());
    protected int colorIndex = -1;

    @Override
    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    @Override
    public void addModel(TextureAtlasSprite[] textures, int colorIndex) {
        this.setColorIndex(colorIndex);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addFace(facing, textures[facing.ordinal()]);
        }
    }

    @Override
    public void addModel(TextureAtlasSprite texture, int colorIndex) {
        this.addModel(new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    @Override
    public void addBlockModel(@Nullable BlockPos pos, TextureAtlasSprite[] textures, int colorIndex) {
        this.setColorIndex(colorIndex);
        if (pos != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IBlockState state = world.func_180495_p(pos);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!state.func_185894_c((IBlockAccess)world, pos, facing)) continue;
                this.addFace(facing, textures[facing.ordinal()]);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.addFace(facing, textures[facing.ordinal()]);
            }
        }
    }

    @Override
    public void addBlockModel(@Nullable BlockPos pos, TextureAtlasSprite texture, int colorIndex) {
        this.addBlockModel(pos, new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    @Override
    public void addBakedModel(@Nullable IBlockState state, IBakedModel model) {
        this.bakedModels.add((Pair<IBlockState, IBakedModel>)Pair.of((Object)state, (Object)model));
    }

    @Override
    public void addFace(EnumFacing facing, TextureAtlasSprite sprite) {
        if (sprite != Minecraft.func_71410_x().func_147117_R().field_94249_f) {
            this.faces.add(new ModelBakerFace(facing, this.colorIndex, sprite));
        }
    }

    @Override
    public IModelBakerModel bakeModel(boolean flip) {
        ModelRotation modelRotation = ModelRotation.X0_Y0;
        if (flip) {
            modelRotation = ModelRotation.X0_Y180;
        }
        for (Pair<IBlockState, IBakedModel> bakedModel : this.bakedModels) {
            this.currentModel.addModelQuads(bakedModel);
        }
        for (ModelBakerFace face : this.faces) {
            EnumFacing facing = face.face;
            BlockFaceUV uvFace = new BlockFaceUV(UVS, 0);
            BlockPartFace partFace = new BlockPartFace(facing, face.colorIndex, "", uvFace);
            BakedQuad quad = FACE_BAKERY.func_178414_a(POS_FROM, POS_TO, partFace, face.spite, facing, modelRotation, null, true, true);
            this.currentModel.addQuad(facing, quad);
        }
        return this.currentModel;
    }

    @Override
    public void setModelState(@Nullable IModelState modelState) {
        this.currentModel.setModelState(modelState);
    }

    @Override
    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.currentModel.setParticleSprite(particleSprite);
    }
}

