/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Preconditions;
import forestry.core.items.ItemCrated;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.ModelManager;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ModelUtil;
import forestry.storage.PluginStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelCrate
extends BlankModel {
    private static final Map<String, IBakedModel> cache = new HashMap<String, IBakedModel>();
    private static final String CUSTOM_CRATES = "forestry:item/crates/";

    public static void onModelBake(ModelBakeEvent event) {
        cache.clear();
    }

    @Override
    public ItemOverrideList createOverrides() {
        return new CrateOverrideList();
    }

    @Nullable
    private static IBakedModel getCustomContentModel(ItemCrated crateItem) {
        IModel model;
        ResourceLocation registryName = crateItem.getRegistryName();
        String containedName = registryName.func_110623_a().replace("crated.", "");
        ResourceLocation location = new ResourceLocation(CUSTOM_CRATES + containedName);
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)location);
        }
        catch (Exception e) {
            return null;
        }
        return model.bake(ModelManager.getInstance().getDefaultItemState(), DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE);
    }

    private List<IBakedModel> bakeModel(ItemCrated crateItem) {
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        ItemStack contained = crateItem.getContained();
        if (!contained.func_190926_b()) {
            IBakedModel containedModel = ModelCrate.getCustomContentModel(crateItem);
            if (containedModel == null) {
                containedModel = ModelUtil.getModel(contained);
            }
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, 0.0625f, 0.5f));
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, -0.0625f, 0.5f));
        }
        return models;
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    public static class BakedCrateModel
    extends BlankModel
    implements IBakedModel {
        private final BakedCrateModel other;
        private final boolean gui;
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private final List<BakedQuad> emptyList = new ArrayList<BakedQuad>();

        public BakedCrateModel(BakedCrateModel noneGui) {
            this.gui = true;
            this.other = noneGui;
            for (BakedQuad quad : this.other.quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                this.quads.add(quad);
            }
        }

        public BakedCrateModel(List<BakedQuad> data) {
            this.quads.addAll(data);
            this.gui = false;
            this.other = new BakedCrateModel(this);
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return side == null ? this.quads : this.emptyList;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)ModelManager.getInstance().getDefaultItemState(), (ItemCameraTransforms.TransformType)cameraTransformType);
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI && !this.gui && pair.getRight() == null) {
                return Pair.of((Object)this.other, null);
            }
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI && this.gui) {
                return Pair.of((Object)this.other, (Object)pair.getRight());
            }
            return pair;
        }
    }

    private class CrateOverrideList
    extends ItemOverrideList {
        public CrateOverrideList() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            ItemCrated crated = (ItemCrated)stack.func_77973_b();
            ResourceLocation itemName = ItemStackUtil.getItemNameFromRegistry(crated);
            Preconditions.checkNotNull((Object)itemName);
            String crateUID = itemName.func_110623_a();
            IBakedModel model = (IBakedModel)cache.get(crateUID);
            if (model == null) {
                LinkedList<BakedQuad> list = new LinkedList<BakedQuad>();
                IBakedModel baseCrateModel = (IBakedModel)cache.get("base");
                if (baseCrateModel == null) {
                    baseCrateModel = ModelUtil.getModel(new ItemStack((Item)PluginStorage.getItems().crate, 1, 1));
                    baseCrateModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)baseCrateModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
                }
                for (BakedQuad quad : baseCrateModel.func_188616_a(null, null, 0L)) {
                    list.add(new BakedQuad(quad.func_178209_a(), 100, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
                }
                List textures = ModelCrate.this.bakeModel(crated);
                for (IBakedModel bakybake : textures) {
                    list.addAll(ForgeHooksClient.handleCameraTransforms((IBakedModel)bakybake, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false).func_188616_a(null, null, 0L));
                }
                model = new BakedCrateModel(list);
                cache.put(crateUID, model);
            }
            return model;
        }
    }
}

