/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextLayoutHelper {
    private static final int LINE_HEIGHT = 12;
    private final GuiForestry guiForestry;
    private final int defaultFontColor;
    public int column0;
    public int column1;
    public int column2;
    public int line;

    public TextLayoutHelper(GuiForestry guiForestry, ColourProperties fontColour) {
        this.guiForestry = guiForestry;
        this.defaultFontColor = fontColour.get("gui.screen");
    }

    public void startPage() {
        this.line = 12;
        GlStateManager.func_179094_E();
    }

    public void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    public int getLineY() {
        return this.line;
    }

    public void newLine() {
        this.line += 12;
    }

    public void newLineCompressed() {
        this.line += 10;
    }

    public void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    public void endPage() {
        GlStateManager.func_179121_F();
    }

    public void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
    }

    public void drawLine(String text, int x) {
        this.drawLine(text, x, this.defaultFontColor);
    }

    public void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.defaultFontColor);
    }

    public void drawCenteredLine(String text, int x, int color) {
        this.drawCenteredLine(text, x, this.guiForestry.getSizeX(), color);
    }

    public void drawCenteredLine(String text, int x, int width, int color) {
        this.guiForestry.getFontRenderer().func_78276_b(text, this.guiForestry.getGuiLeft() + x + this.getCenteredOffset(text, width), this.guiForestry.getGuiTop() + this.line, color);
    }

    public void drawLine(String text, int x, int color) {
        this.guiForestry.getFontRenderer().func_78276_b(text, this.guiForestry.getGuiLeft() + x, this.guiForestry.getGuiTop() + this.line, color);
    }

    public void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.guiForestry.getFontRenderer().func_78279_b(text, this.guiForestry.getGuiLeft() + x, this.guiForestry.getGuiTop() + this.line, maxWidth, color);
    }

    public int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.guiForestry.getSizeX());
    }

    public int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.guiForestry.getFontRenderer().func_78256_a(string)) / 2;
    }
}

