/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimateManager;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimateSourceProvider;
import forestry.api.core.ForestryAPI;
import forestry.core.DefaultClimateProvider;
import forestry.core.climate.BiomeClimateInfo;
import forestry.core.climate.ClimateInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimateManager
implements IClimateManager {
    protected final Map<World, List<IClimateRegion>> regions = new HashMap<World, List<IClimateRegion>>();
    private final Object regionsMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(IClimateRegion region) {
        Object object = this.regionsMutex;
        synchronized (object) {
            List<IClimateRegion> regions;
            World world = region.getWorld();
            if (!this.regions.containsKey(world)) {
                this.regions.put(world, new ArrayList());
            }
            if (!(regions = this.regions.get(world)).contains(region)) {
                if (!regions.isEmpty()) {
                    for (IClimatePosition pos : region.getPositions()) {
                        if (this.getRegionForPos(world, pos.getPos()) == null) continue;
                        return;
                    }
                }
                regions.add(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegion(IClimateRegion region) {
        Object object = this.regionsMutex;
        synchronized (object) {
            World world = region.getWorld();
            if (!this.regions.containsKey(world)) {
                this.regions.put(world, new ArrayList());
            }
            List<IClimateRegion> regions = this.regions.get(world);
            regions.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(IClimateSourceProvider source) {
        Object object = this.regionsMutex;
        synchronized (object) {
            IClimateRegion region;
            World world = source.getWorldObj();
            if (!this.regions.containsKey(world)) {
                this.regions.put(world, new ArrayList());
            }
            if ((region = this.getRegionForPos(source.getWorldObj(), source.getCoordinates())) != null && region.getSources().contains(source.getClimateSource())) {
                region.removeSource(source.getClimateSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSource(IClimateSourceProvider source) {
        Object object = this.regionsMutex;
        synchronized (object) {
            IClimateRegion region;
            World world = source.getWorldObj();
            if (!this.regions.containsKey(world)) {
                this.regions.put(world, new ArrayList());
            }
            if ((region = this.getRegionForPos(source.getWorldObj(), source.getCoordinates())) != null && !region.getSources().contains(source.getClimateSource())) {
                region.addSource(source.getClimateSource());
            }
        }
    }

    @Override
    public IClimateInfo createInfo(float temperature, float humidity) {
        return new ClimateInfo(temperature, humidity);
    }

    @Override
    public IClimateInfo getInfo(World world, BlockPos pos) {
        IClimatePosition position = ForestryAPI.climateManager.getPosition(world, pos);
        if (position != null) {
            return position.getInfo();
        }
        return BiomeClimateInfo.getInfo(world.func_180494_b(pos));
    }

    @Override
    public Map<World, List<IClimateRegion>> getRegions() {
        return this.regions;
    }

    @Override
    public IClimatePosition getPosition(World world, BlockPos pos) {
        if (!this.regions.containsKey(world)) {
            this.regions.put(world, new ArrayList());
            return null;
        }
        for (IClimateRegion region : this.regions.get(world)) {
            IClimatePosition position = region.getPosition(pos);
            if (position == null) continue;
            return position;
        }
        return null;
    }

    @Override
    public IClimateRegion getRegionForPos(World world, BlockPos pos) {
        if (!this.regions.containsKey(world)) {
            this.regions.put(world, new ArrayList());
        }
        List<IClimateRegion> regions = this.regions.get(world);
        for (IClimateRegion region : regions) {
            if (region.getPosition(pos) == null) continue;
            return region;
        }
        return null;
    }

    @Override
    public void onWorldUnload(World world) {
        this.regions.remove(world);
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }
}

