/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.core.utils.SlotUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryApiary
extends InventoryBeeHousing
implements IApiaryInventory {
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_COUNT = 3;

    public InventoryApiary() {
        super(12);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return itemStack.func_77973_b() instanceof IHiveFrame && this.func_70301_a(slotIndex).func_190926_b();
        }
        return super.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return !SlotUtil.isSlotInRange(slotIndex, 9, 3) && super.func_94041_b(slotIndex, itemStack);
    }

    public Collection<IHiveFrame> getFrames() {
        ArrayList<IHiveFrame> hiveFrames = new ArrayList<IHiveFrame>(3);
        for (int i = 9; i < 12; ++i) {
            ItemStack stackInSlot = this.func_70301_a(i);
            Item itemInSlot = stackInSlot.func_77973_b();
            if (!(itemInSlot instanceof IHiveFrame)) continue;
            hiveFrames.add((IHiveFrame)itemInSlot);
        }
        return hiveFrames;
    }

    @Override
    public void wearOutFrames(IBeeHousing beeHousing, int amount) {
        IBeekeepingMode beekeepingMode = BeeManager.beeRoot.getBeekeepingMode(beeHousing.getWorldObj());
        int wear = Math.round((float)amount * beekeepingMode.getWearModifier());
        for (int i = 9; i < 12; ++i) {
            ItemStack hiveFrameStack = this.func_70301_a(i);
            Item hiveFrameItem = hiveFrameStack.func_77973_b();
            if (!(hiveFrameItem instanceof IHiveFrame)) continue;
            IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
            ItemStack queenStack = this.getQueen();
            IBee queen = BeeManager.beeRoot.getMember(queenStack);
            if (queen == null) continue;
            ItemStack usedFrame = hiveFrame.frameUsed(beeHousing, hiveFrameStack, queen, wear);
            this.func_70299_a(i, usedFrame);
        }
    }
}

