/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import forestry.api.climate.ClimateManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ForestryEvent;
import forestry.core.EventHandlerCore;
import forestry.core.advancements.AdvancementManager;
import forestry.core.climate.ClimateFactory;
import forestry.core.climate.ClimateRoot;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.GameMode;
import forestry.core.errors.EnumErrorCode;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.gui.GuiHandler;
import forestry.core.multiblock.MultiblockEventHandler;
import forestry.core.network.PacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.MigrationHelper;
import forestry.core.worldgen.WorldGenerator;
import forestry.modules.ForestryModules;
import forestry.modules.ModuleManager;
import forestry.plugins.ForestryCompatPlugins;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="forestry", name="Forestry", version="5.8.2.418", guiFactory="forestry.core.config.ForestryGuiConfigFactory", acceptedMinecraftVersions="[1.12.2,1.13.0)", dependencies="required-after:forge@[14.23.5.2847,);after:jei@[4.12.0.0,);after:ic2;after:natura;after:toughasnails;after:techreborn;after:buildcraftenergy;before:binniecore@[2.5.1.184,)")
public class Forestry {
    @Mod.Instance(value="forestry")
    public static Forestry instance;
    @Nullable
    private File configFolder;
    @Nullable
    private static PacketHandler packetHandler;

    public Forestry() {
        ForestryAPI.instance = this;
        ForestryAPI.forestryConstants = new Constants();
        ForestryAPI.errorStateRegistry = new ErrorStateRegistry();
        ForestryAPI.climateManager = ClimateRoot.getInstance();
        ClimateManager.climateRoot = ForestryAPI.climateManager;
        ClimateManager.climateFactory = ClimateFactory.INSTANCE;
        ClimateManager.stateHelper = ClimateStateHelper.INSTANCE;
        EnumErrorCode.init();
        FluidRegistry.enableUniversalBucket();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModuleManager moduleManager = ModuleManager.getInstance();
        ForestryAPI.moduleManager = moduleManager;
        moduleManager.registerContainers(new ForestryModules(), new ForestryCompatPlugins());
    }

    public static PacketHandler getPacketHandler() {
        Preconditions.checkNotNull((Object)packetHandler);
        return packetHandler;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        EventHandlerCore eventHandlerCore = new EventHandlerCore();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerCore);
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        MinecraftForge.EVENT_BUS.register(Config.class);
        Proxies.common.registerEventHandlers();
        this.configFolder = new File(event.getModConfigurationDirectory(), "forestry");
        Config.load(event.getSide());
        MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.PreInit(this, event));
        ModuleManager.runSetup(event);
        ModuleManager.getInternalHandler().runSetup();
        String gameMode = Config.gameMode;
        Preconditions.checkNotNull((Object)gameMode);
        ForestryAPI.activeMode = new GameMode(gameMode);
        MigrationHelper.registerFixable();
        ModuleManager.getInternalHandler().runPreInit(event.getSide());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerItems(RegistryEvent.Register<Item> event) {
        ModuleManager.getInternalHandler().runRegisterBackpacksAndCrates();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Proxies.render.registerModels();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ModuleManager.getInternalHandler().runInit();
        Proxies.render.registerItemAndBlockColors();
        AdvancementManager.registerTriggers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleManager.getInternalHandler().runPostInit();
        WorldGenerator worldGenerator = new WorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)0);
        Proxies.common.registerTickHandlers(worldGenerator);
        ModuleManager.getInternalHandler().processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ModuleManager.serverStarting(event.getServer());
    }

    @Nullable
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        ModuleManager.getInternalHandler().processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }
}

