/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.farming.logic.FarmLogicWatered;
import forestry.farming.logic.crops.CropPeat;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicPeat
extends FarmLogicWatered {
    public FarmLogicPeat(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.peat";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing housing, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockBogEarth.SoilType soilType;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            if (!world.func_175667_e(position)) {
                return crops;
            }
            IBlockState blockState = world.func_180495_p(position);
            Block block = blockState.func_177230_c();
            if (!(block instanceof BlockBogEarth) || (soilType = BlockBogEarth.getTypeFromState(blockState)) != BlockBogEarth.SoilType.PEAT) continue;
            crops.push(new CropPeat(world, position));
        }
        return crops;
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack((Item)ModuleCore.getItems().peat);
    }
}

