/*
 * Decompiled with CFR 0.152.
 */
package forestry.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.book.BookContent;
import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntryBuilder;
import forestry.api.book.IBookLoader;
import forestry.api.book.IBookPageFactory;
import forestry.api.book.IForesterBook;
import forestry.book.BookCategory;
import forestry.book.ForesterBook;
import forestry.book.data.EntryData;
import forestry.book.data.content.CarpenterContent;
import forestry.book.data.content.CraftingContent;
import forestry.book.data.content.FabricatorContent;
import forestry.book.data.content.ImageContent;
import forestry.book.data.content.IndexContent;
import forestry.book.data.content.MutationContent;
import forestry.book.data.content.StructureContent;
import forestry.book.data.content.TextContent;
import forestry.book.data.deserializer.BookCategoryDeserializer;
import forestry.book.data.deserializer.BookContentDeserializer;
import forestry.book.pages.JsonPageFactory;
import forestry.core.utils.JsonUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ResourceUtil;
import forestry.modules.ModuleHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class BookLoader
implements IResourceManagerReloadListener,
IBookLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BookContent.class, (Object)new BookContentDeserializer()).registerTypeAdapter(BookCategory.class, (Object)new BookCategoryDeserializer()).registerTypeAdapter(ResourceLocation.class, (json, typeOfT, context) -> new ResourceLocation(JsonUtils.func_151206_a((JsonElement)json, (String)"location"))).registerTypeAdapter(ItemStack.class, (json, typeOfT, context) -> JsonUtil.deserializeItemStack(json.getAsJsonObject(), ItemStack.field_190927_a)).registerTypeAdapter(Entries.class, (Object)new EntriesDeserializer()).create();
    public static final BookLoader INSTANCE = new BookLoader();
    private static final String BOOK_LOCATION = "forestry:manual/";
    private static final String BOOK_LOCATION_LANG = "forestry:manual/%s/%s";
    private static final String DEFAULT_LANG = "en_US";
    private final Map<String, Class<? extends BookContent>> contentByType = new HashMap<String, Class<? extends BookContent>>();
    private final Map<String, IBookPageFactory> factoryByName = new HashMap<String, IBookPageFactory>();
    @Nullable
    private ForesterBook book = null;

    private BookLoader() {
        this.registerContentType("text", TextContent.class);
        this.registerContentType("image", ImageContent.class);
        this.registerContentType("crafting", CraftingContent.class);
        this.registerContentType("mutation", MutationContent.class);
        this.registerContentType("carpenter", CarpenterContent.class);
        this.registerContentType("structure", StructureContent.class);
        this.registerContentType("index", IndexContent.class);
        this.registerContentType("fabricator", FabricatorContent.class);
        this.registerPageFactory("json", JsonPageFactory.INSTANCE);
    }

    @Override
    public void registerContentType(String name, Class<? extends BookContent> contentClass) {
        this.contentByType.put(name, contentClass);
    }

    @Override
    public void registerPageFactory(String name, IBookPageFactory factory) {
        this.factoryByName.put(name, factory);
    }

    @Override
    public IBookPageFactory getPageFactory(String name) {
        IBookPageFactory factory = this.factoryByName.get(name);
        if (factory == null) {
            return JsonPageFactory.INSTANCE;
        }
        return factory;
    }

    @Override
    public IForesterBook loadBook() {
        if (this.book != null) {
            return this.book;
        }
        this.book = new ForesterBook();
        IBookCategory[] categories = this.fromJson("forestry:manual/categories.json", BookCategory[].class, new BookCategory[0]);
        if (categories != null) {
            this.book.addCategories(categories);
            for (IBookCategory category : categories) {
                this.loadCategory((BookCategory)category);
            }
        }
        return this.book;
    }

    @Override
    public void invalidateBook() {
        this.book = null;
    }

    @Nullable
    public static IResource getResource(String path) {
        if (!path.contains(":")) {
            Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
            String lang = currentLanguage.func_135034_a();
            ResourceLocation location = new ResourceLocation(String.format(BOOK_LOCATION_LANG, lang, path));
            IResource resource = ResourceUtil.getResource(location);
            if (resource != null) {
                return resource;
            }
            location = new ResourceLocation(String.format(BOOK_LOCATION_LANG, DEFAULT_LANG, path));
            resource = ResourceUtil.getResource(location);
            if (resource != null) {
                return resource;
            }
            location = new ResourceLocation(BOOK_LOCATION + path);
            return ResourceUtil.getResource(location);
        }
        ResourceLocation location = new ResourceLocation(path);
        return ResourceUtil.getResource(location);
    }

    @Nullable
    public Class<? extends BookContent> getContentType(String name) {
        return this.contentByType.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCategory(BookCategory category) {
        ResourceLocation entriesLocation = new ResourceLocation("forestry:manual/entries/" + category.getName() + ".json");
        LinkedList entryNames = new LinkedList();
        for (IResource entryResource : ResourceUtil.getResources(entriesLocation)) {
            try {
                BufferedReader reader = ResourceUtil.createReader(entryResource);
                Throwable throwable = null;
                try {
                    Entries entries = (Entries)GSON.fromJson((Reader)reader, Entries.class);
                    entryNames.addAll(entries.names);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.error("Failed to parse entries file {}.{}", entriesLocation, e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)entryResource);
            }
        }
        HashMap entries = new HashMap(entryNames.size());
        entryNames.forEach(entry -> this.loadEntries(entries, (String)entry));
        entryNames.forEach(entry -> this.createEntry(entries, category, (String)entry));
    }

    private void createEntry(Map<String, EntryData> entries, BookCategory category, String entry) {
        EntryData data = entries.get(entry);
        if (data != null) {
            IBookEntryBuilder builder = category.createEntry(entry);
            builder.setStack(data.icon);
            builder.setContent(data.content);
            builder.setTitle(data.title);
            builder.setLoader(INSTANCE.getPageFactory(data.loader));
            for (String subEntry : data.subEntries) {
                EntryData subData = entries.get(subEntry);
                if (subData == null) continue;
                IBookEntryBuilder subBuilder = builder.createSubEntry(subEntry, subData.icon);
                subBuilder.setContent(subData.content);
                subBuilder.setTitle(subData.title);
                builder.setLoader(INSTANCE.getPageFactory(subData.loader));
            }
            builder.addToCategory();
        }
    }

    private void loadEntries(Map<String, EntryData> entries, String entry) {
        EntryData data = this.fromJson(entry + ".json", EntryData.class, null);
        if (data != null) {
            entries.put(entry, data);
            for (String subEntry : data.subEntries) {
                this.loadEntries(entries, subEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private <T> T fromJson(String location, Class<T> classOfT, @Nullable T fallback) {
        IResource resource = BookLoader.getResource(location);
        if (resource == null) {
            return fallback;
        }
        try {
            Object object;
            Throwable throwable;
            BufferedReader reader;
            block18: {
                block19: {
                    reader = ResourceUtil.createReader(resource);
                    throwable = null;
                    object = GSON.fromJson((Reader)reader, classOfT);
                    if (reader == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                reader.close();
            }
            return (T)object;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    Log.error("Failed to load resource {}: {}", location, e);
                    throwable = fallback;
                    return (T)throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.invalidateBook();
    }

    private static class EntriesDeserializer
    implements JsonDeserializer<Entries> {
        private EntriesDeserializer() {
        }

        public Entries deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            Entries entries = new Entries();
            this.parseElement(entries, json, context);
            return entries;
        }

        private void parseElement(Entries entries, JsonElement element, JsonDeserializationContext context) {
            if (element.isJsonArray()) {
                String[] array = (String[])context.deserialize(element, String[].class);
                entries.names.addAll(Arrays.asList(array));
            } else {
                JsonObject object = element.getAsJsonObject();
                for (Map.Entry member : object.entrySet()) {
                    if (!ModuleHelper.isEnabled((String)member.getKey())) continue;
                    this.parseElement(entries, (JsonElement)member.getValue(), context);
                }
            }
        }
    }

    private static class Entries {
        private final List<String> names = new LinkedList<String>();

        private Entries() {
        }
    }
}

