package forestry.cultivation.gui;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import forestry.core.ModuleCore;
import forestry.core.config.Constants;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.cultivation.gui.widgets.GhostItemStackWidget;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.cultivation.tiles.TilePlanter;
import forestry.farming.gui.FarmLedger;

public class GuiPlanter extends GuiForestryTitled<ContainerPlanter> {
	private final TilePlanter tile;

	public GuiPlanter(TilePlanter tile, InventoryPlayer playerInventory) {
		super(Constants.TEXTURE_PATH_GUI + "/planter.png", new ContainerPlanter(tile, playerInventory), tile);
		this.tile = tile;
		this.field_146999_f = 202;
		this.field_147000_g = 192;

		NonNullList<ItemStack> resourceStacks = tile.createResourceStacks();
		NonNullList<ItemStack> germlingStacks = tile.createGermlingStacks();
		NonNullList<ItemStack> productionStacks = tile.createProductionStacks();

		widgetManager.add(new TankWidget(widgetManager, 178, 44, 0).setOverlayOrigin(field_146999_f, 18));

		// Resources
		for (int i = 0; i < 2; i++) {
			for (int j = 0; j < 2; j++) {
				int index = j + i * 2;
				if (resourceStacks.size() == 4) {
					widgetManager.add(new GhostItemStackWidget(widgetManager, 11 + j * 18, 65 + i * 18, resourceStacks.get(index), field_147002_h.func_75139_a(36 + InventoryPlanter.SLOT_RESOURCES_1 + index)));
				}
			}
		}

		// Germlings
		for (int i = 0; i < 2; i++) {
			for (int j = 0; j < 2; j++) {
				int index = j + i * 2;
				if (germlingStacks.size() == 4) {
					widgetManager.add(new GhostItemStackWidget(widgetManager, 71 + j * 18, 65 + i * 18, germlingStacks.get(index), field_147002_h.func_75139_a(36 + InventoryPlanter.SLOT_GERMLINGS_1 + index)));
				}
			}
		}

		// Production
		for (int i = 0; i < 2; i++) {
			for (int j = 0; j < 2; j++) {
				int index = j + i * 2;
				if (productionStacks.size() == 4) {
					widgetManager.add(new GhostItemStackWidget(widgetManager, 131 + j * 18, 65 + i * 18, productionStacks.get(index), field_147002_h.func_75139_a(36 + InventoryPlanter.SLOT_PRODUCTION_1 + j + i * 2)));
				}
			}
		}

		widgetManager.add(new GhostItemStackWidget(widgetManager, 83, 22, new ItemStack(ModuleCore.getItems().fertilizerCompound), field_147002_h.func_75139_a(36 + InventoryPlanter.SLOT_FERTILIZER)));
	}

	@Override
	protected void addLedgers() {
		addErrorLedger(tile);
		addClimateLedger(tile);
		ledgerManager.add(new FarmLedger(ledgerManager, tile.getFarmLedgerDelegate()));
		addOwnerLedger(tile);
	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {
		super.func_146976_a(var1, mouseX, mouseY);

		// Fuel remaining
		int fertilizerRemain = tile.getStoredFertilizerScaled(16);
		if (fertilizerRemain > 0) {
			func_73729_b(field_147003_i + 101, field_147009_r + 21 + 17 - fertilizerRemain, field_146999_f, 17 - fertilizerRemain, 4, fertilizerRemain);
		}
	}
}
