package forestry.core.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;

import forestry.core.utils.Log;
import forestry.core.utils.MigrationHelper;

public class TileEntityDataFixable implements IFixableData {
	@Override
	public int func_188216_a() {
		return 1;
	}

	@Override
	public NBTTagCompound func_188217_a(NBTTagCompound compound) {
		String oldName = compound.func_74779_i("id").replace("minecraft:", "");
		if (oldName.startsWith("forestry.")) {
			String remappedName = MigrationHelper.getRemappedTileName(oldName);
			if (remappedName != null) {
				Log.debug("Replaced old Tile Entity name '{}' with the remapped name '{}'.", oldName, remappedName);
				compound.func_74778_a("id", remappedName);
			} else {
				Log.error("Failed to find remapped name for the Tile Entity with the name {}.", oldName);
			}
		}
		return compound;
	}
}
