/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.render;

import javax.annotation.Nullable;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import forestry.core.blocks.BlockBase;
import forestry.core.config.Constants;
import forestry.core.models.ModelEscritoire;
import forestry.core.tiles.TileEscritoire;

public class RenderEscritoire extends TileEntitySpecialRenderer<TileEscritoire> {

	private static final ResourceLocation texture = new ForestryResource(Constants.TEXTURE_PATH_BLOCKS + "/escritoire.png");
	private final ModelEscritoire modelEscritoire = new ModelEscritoire();
	@Nullable
	private EntityItem dummyEntityItem;
	private long lastTick;

	private EntityItem dummyItem(World world) {
		if (dummyEntityItem == null) {
			dummyEntityItem = new EntityItem(world);
		} else {
			dummyEntityItem.field_70170_p = world;
		}
		return dummyEntityItem;
	}

	/**
	 * @param escritoire If it null its render the item else it render the tile entity.
	 */
	@Override
	public void func_192841_a(TileEscritoire escritoire, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
		if (escritoire != null) {
			World world = escritoire.getWorldObj();
			if (world.func_175667_e(escritoire.func_174877_v())) {
				IBlockState blockState = world.func_180495_p(escritoire.func_174877_v());
				if (blockState.func_177230_c() instanceof BlockBase) {
					EnumFacing facing = blockState.func_177229_b(BlockBase.FACING);
					render(escritoire.getIndividualOnDisplay(), world, facing, x, y, z);
					return;
				}
			}
		}
		render(ItemStack.field_190927_a, null, EnumFacing.SOUTH, x, y, z);
	}

	private void render(ItemStack itemstack, @Nullable World world, EnumFacing orientation, double x, double y, double z) {
		float factor = (float) (1.0 / 16.0);

		Minecraft minecraft = Minecraft.func_71410_x();
		GlStateManager.func_179094_E();
		{
			GlStateManager.func_179109_b((float) x + 0.5f, (float) y + 0.875f, (float) z + 0.5f);

			float[] angle = {(float) Math.PI, 0, 0};

			switch (orientation) {
				case EAST:
					angle[1] = (float) Math.PI / 2;
					break;
				case SOUTH:
					break;
				case NORTH:
					angle[1] = (float) Math.PI;
					break;
				case WEST:
				default:
					angle[1] = -(float) Math.PI / 2;
					break;
			}

			TextureManager textureManager = minecraft.func_110434_K();
			textureManager.func_110577_a(texture);
			modelEscritoire.func_78088_a(null, angle[0], angle[1], angle[2], 0f, 0f, factor);
		}
		GlStateManager.func_179121_F();

		if (!itemstack.func_190926_b() && world != null) {
			EntityItem dummyItem = dummyItem(world);

			float renderScale = 0.75f;

			GlStateManager.func_179094_E();
			{
				GlStateManager.func_179109_b((float) x + 0.5f, (float) y + 0.6f, (float) z + 0.5f);
				GlStateManager.func_179152_a(renderScale, renderScale, renderScale);
				dummyItem.func_92058_a(itemstack);

				if (world.func_82737_E() != lastTick) {
					lastTick = world.func_82737_E();
					dummyItem.func_70071_h_();
				}

				RenderManager rendermanager = minecraft.func_175598_ae();
				rendermanager.func_188391_a(dummyItem, 0.0D, 0.0D, 0.0D, 0.0F, 0.0F, false);
			}
			GlStateManager.func_179121_F();

			dummyItem.field_70170_p = null; // prevent leaking the world object
		}
	}
}
