/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.items;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemTooltipUtil;

public class ItemBlockForestry<B extends Block> extends ItemBlock {

	public ItemBlockForestry(B block) {
		super(block);
		func_77656_e(0);
		func_77627_a(true);
	}

	@Override
	public B func_179223_d() {
		//noinspection unchecked
		return (B) super.func_179223_d();
	}

	@Override
	public int func_77647_b(int i) {
		return i;
	}

	@Override
	public String func_77667_c(ItemStack itemstack) {
		Block block = func_179223_d();
		if (block instanceof IBlockWithMeta) {
			IBlockWithMeta blockMeta = (IBlockWithMeta) block;
			int meta = itemstack.func_77960_j();
			return block.func_149739_a() + "." + blockMeta.getNameFromMeta(meta);
		}
		return block.func_149739_a();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
		super.func_77624_a(stack, world, tooltip, advanced);
		ItemTooltipUtil.addInformation(stack, world, tooltip, advanced);
	}

	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
		boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);

		if (placed) {
			if (field_150939_a.hasTileEntity(newState)) {
				if (stack.func_77973_b() instanceof ItemBlockNBT && stack.func_77978_p() != null) {
					TileForestry tile = TileUtil.getTile(world, pos, TileForestry.class);
					if (tile != null) {
						tile.func_145839_a(stack.func_77978_p());
						tile.func_174878_a(pos);
					}
				}
			}

			if (field_150939_a instanceof IBlockRotatable) {
				((IBlockRotatable) field_150939_a).rotateAfterPlacement(player, world, pos, side);
			}
		}

		return placed;
	}
}
