/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.genetics.alleles;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VectUtil;

public class AlleleEffectSnowing extends AlleleEffectThrottled {

	public AlleleEffectSnowing() {
		super("snowing", false, 20, true, true);
	}

	@Override
	public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {

		World world = housing.getWorldObj();

		EnumTemperature temp = housing.getTemperature();

		switch (temp) {
			case HELLISH:
			case HOT:
			case WARM:
				return storedData;
			default:
		}

		Vec3i area = getModifiedArea(genome, housing);
		Vec3i offset = VectUtil.scale(area, -1 / 2.0f);

		for (int i = 0; i < 1; i++) {

			BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);

			BlockPos posBlock = randomPos.func_177971_a(housing.getCoordinates()).func_177971_a(offset);

			// Put snow on the ground
			if (world.func_175667_e(posBlock) && world.isSideSolid(posBlock.func_177977_b(), EnumFacing.UP, false)) {
				IBlockState state = world.func_180495_p(posBlock);
				Block block = state.func_177230_c();

				if (block == Blocks.field_150431_aC) {
					Integer layers = state.func_177229_b(BlockSnow.field_176315_a);
					if (layers < 7) {
						IBlockState moreSnow = state.func_177226_a(BlockSnow.field_176315_a, layers + 1);
						world.func_175656_a(posBlock, moreSnow);
					} else {
						world.func_175656_a(posBlock, Blocks.field_150433_aE.func_176223_P());
					}
				} else if (block.func_176200_f(world, posBlock)) {
					world.func_175656_a(posBlock, Blocks.field_150431_aC.func_176223_P());
				}
			}
		}

		return storedData;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
		if (housing.getWorldObj().field_73012_v.nextInt(3) == 0) {
			Vec3i area = getModifiedArea(genome, housing);
			Vec3i offset = VectUtil.scale(area, -0.5F);

			BlockPos coordinates = housing.getCoordinates();
			World world = housing.getWorldObj();

			BlockPos spawn = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a(coordinates).func_177971_a(offset);
			ParticleRender.addEntitySnowFX(world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
			return storedData;
		} else {
			return super.doFX(genome, storedData, housing);
		}
	}

}
