/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.ForestryAPI;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.climatology.gui.GuiHabitatFormer;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HabitatSelectionElement
extends ElementGroup {
    private static final Comparator<ClimateButton> BUTTON_COMPARATOR = Comparator.comparingDouble(rec$ -> ClimateButton.access$300((ClimateButton)rec$));
    private final List<ClimateButton> buttons = new ArrayList<ClimateButton>();
    private final IClimateTransformer transformer;

    public HabitatSelectionElement(int xPos, int yPos, IClimateTransformer transformer) {
        super(xPos, yPos, 60, 40);
        this.transformer = transformer;
        int x = 0;
        int y = 0;
        for (EnumClimate climate : EnumClimate.values()) {
            ClimateButton button = new ClimateButton(climate, x * 20, y * 20);
            this.buttons.add(button);
            this.add(button);
            if (++x < 3) continue;
            ++y;
            x = 0;
        }
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        super.drawElement(mouseX, mouseY);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
        Optional<ClimateButton> optional = this.buttons.stream().min(BUTTON_COMPARATOR);
        if (!optional.isPresent()) {
            return;
        }
        ClimateButton button = optional.get();
        this.func_73729_b(button.getX() - 1, button.getY() - 1, 0, 233, 22, 22);
    }

    private class ClimateButton
    extends GuiElement {
        final EnumClimate climate;

        private ClimateButton(EnumClimate climate, int xPos, int yPos) {
            super(xPos, yPos, 20, 20);
            this.climate = climate;
            this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
                IClimateState climateState = climate.climateState;
                GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
                former.setClimate(climateState);
                former.sendClimateUpdate();
            });
            this.addTooltip((Collection<String> tooltip, IGuiElement element, int mouseX, int mouseY) -> {
                tooltip.add("T: " + StringUtil.floatAsPercent(climate.climateState.getTemperature()));
                tooltip.add("H: " + StringUtil.floatAsPercent(climate.climateState.getHumidity()));
            });
        }

        @Override
        public void drawElement(int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(new ResourceLocation("forestry", "textures/gui/habitat_former.png"));
            this.func_73729_b(0, 0, 204, 46, 20, 20);
            TextureManagerForestry.getInstance().bindGuiTextureMap();
            this.func_175175_a(2, 2, this.climate.getSprite(), 16, 16);
        }

        private double getComparingCode() {
            IClimateState target = HabitatSelectionElement.this.transformer.getTarget();
            IClimateState state = this.climate.climateState;
            double temp = target.getTemperature() - state.getTemperature();
            double hem = target.getHumidity() - state.getHumidity();
            return Math.abs(temp + hem);
        }
    }

    private static enum EnumClimate {
        ICY("habitats/snow", Biomes.field_76774_n),
        COLD("habitats/taiga", Biomes.field_76768_g),
        HILLS("habitats/hills", Biomes.field_76780_h),
        NORMAL("habitats/plains", Biomes.field_76772_c),
        WARM("habitats/jungle", Biomes.field_76782_w),
        HOT("habitats/desert", Biomes.field_76769_d);

        private IClimateState climateState;
        private String spriteName;

        private EnumClimate(String spriteName, Biome biome) {
            this.climateState = ClimateStateHelper.of(biome.func_185353_n(), biome.func_76727_i());
            this.spriteName = spriteName;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return ForestryAPI.textureManager.getDefault(this.spriteName);
        }
    }
}

