/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail.gui;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.commons.lang3.StringUtils;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.config.Constants;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoRequest;

import org.lwjgl.input.Keyboard;

public class GuiLetter extends GuiForestry<ContainerLetter> {
	private final ItemInventoryLetter itemInventory;
	private final boolean isProcessedLetter;
	private boolean checkedSessionVars;

	private GuiTextField address;
	private GuiTextBox text;

	private boolean addressFocus;
	private boolean textFocus;

	private final ArrayList<Widget> tradeInfoWidgets;

	public GuiLetter(EntityPlayer player, ItemInventoryLetter itemInventory) {
		super(Constants.TEXTURE_PATH_GUI + "/letter.png", new ContainerLetter(player, itemInventory));

		this.itemInventory = itemInventory;
		this.field_146999_f = 194;
		this.field_147000_g = 227;

		this.isProcessedLetter = container.getLetter().isProcessed();
		this.widgetManager.add(new AddresseeSlot(widgetManager, 16, 12, container));
		this.tradeInfoWidgets = new ArrayList<>();

		address = new GuiTextField(0, this.field_146289_q, field_147003_i + 46, field_147009_r + 13, 93, 13);
		text = new GuiTextBox(1, this.field_146289_q, field_147003_i + 17, field_147009_r + 31, 122, 57);
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		Keyboard.enableRepeatEvents(true);

		address = new GuiTextField(0, this.field_146289_q, field_147003_i + 46, field_147009_r + 13, 93, 13);
		IMailAddress recipient = container.getRecipient();
		if (recipient != null) {
			address.func_146180_a(recipient.getName());
		}

		text = new GuiTextBox(1, this.field_146289_q, field_147003_i + 17, field_147009_r + 31, 122, 57);
		text.func_146203_f(128);
		if (!container.getText().isEmpty()) {
			text.func_146180_a(container.getText());
		}
	}

	@Override
	protected void func_73869_a(char eventCharacter, int eventKey) throws IOException {

		// Set focus or enter text into address
		if (this.address.func_146206_l()) {
			if (eventKey == Keyboard.KEY_RETURN) {
				this.address.func_146195_b(false);
			} else {
				this.address.func_146201_a(eventCharacter, eventKey);
			}
			return;
		}

		if (this.text.func_146206_l()) {
			if (eventKey == Keyboard.KEY_RETURN) {
				if (GuiScreen.func_146272_n()) {
					text.func_146180_a(text.func_146179_b() + "\n");
				} else {
					this.text.func_146195_b(false);
				}
			} else if (eventKey == Keyboard.KEY_DOWN) {
				text.advanceLine();
			} else if (eventKey == Keyboard.KEY_UP) {
				text.regressLine();
			} else if (text.moreLinesAllowed() || eventKey == Keyboard.KEY_DELETE || eventKey == Keyboard.KEY_BACK) {
				this.text.func_146201_a(eventCharacter, eventKey);
			}
			return;
		}

		super.func_73869_a(eventCharacter, eventKey);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.func_73864_a(mouseX, mouseY, mouseButton);

		this.address.func_146192_a(mouseX, mouseY, mouseButton);
		this.text.func_146192_a(mouseX, mouseY, mouseButton);

	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {

		if (!isProcessedLetter && !checkedSessionVars) {
			checkedSessionVars = true;
			setFromSessionVars();
			String recipient = this.address.func_146179_b();
			EnumAddressee recipientType = container.getCarrierType();
			setRecipient(recipient, recipientType);
		}

		// Check for focus changes
		if (addressFocus != address.func_146206_l()) {
			String recipient = this.address.func_146179_b();
			if (StringUtils.isNotBlank(recipient)) {
				EnumAddressee recipientType = container.getCarrierType();
				setRecipient(recipient, recipientType);
			}
		}
		addressFocus = address.func_146206_l();
		if (textFocus != text.func_146206_l()) {
			setText();
		}
		textFocus = text.func_146206_l();

		super.func_146976_a(var1, mouseX, mouseY);

		if (this.isProcessedLetter) {
			field_146289_q.func_78276_b(address.func_146179_b(), field_147003_i + 49, field_147009_r + 16, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
			field_146289_q.func_78279_b(text.func_146179_b(), field_147003_i + 20, field_147009_r + 34, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
		} else {
			clearTradeInfoWidgets();
			address.func_146194_f();
			if (container.getCarrierType() == EnumAddressee.TRADER) {
				drawTradePreview(18, 32);
			} else {
				text.func_146194_f();
			}
		}
	}

	private void drawTradePreview(int x, int y) {

		String infoString = null;
		if (container.getTradeInfo() == null) {
			infoString = Translator.translateToLocal("for.gui.mail.no.trader");
		} else if (container.getTradeInfo().getTradegood().func_190926_b()) {
			infoString = Translator.translateToLocal("for.gui.mail.nothing.to.trade");
		} else if (!container.getTradeInfo().getState().isOk()) {
			infoString = container.getTradeInfo().getState().getDescription();
		}

		if (infoString != null) {
			field_146289_q.func_78279_b(infoString, field_147003_i + x, field_147009_r + y, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
			return;
		}

		field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.mail.pleasesend"), field_147003_i + x, field_147009_r + y, ColourProperties.INSTANCE.get("gui.mail.lettertext"));

		addTradeInfoWidget(new ItemStackWidget(widgetManager, x, y + 10, container.getTradeInfo().getTradegood()));

		field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.mail.foreveryattached"), field_147003_i + x, field_147009_r + y + 28, ColourProperties.INSTANCE.get("gui.mail.lettertext"));

		for (int i = 0; i < container.getTradeInfo().getRequired().size(); i++) {
			addTradeInfoWidget(new ItemStackWidget(widgetManager, x + i * 18, y + 38, container.getTradeInfo().getRequired().get(i)));
		}
	}

	private void addTradeInfoWidget(Widget widget) {
		tradeInfoWidgets.add(widget);
		widgetManager.add(widget);
	}

	private void clearTradeInfoWidgets() {
		for (Widget widget : tradeInfoWidgets) {
			widgetManager.remove(widget);
		}
		tradeInfoWidgets.clear();
	}

	@Override
	public void func_146281_b() {
		String recipientName = this.address.func_146179_b();
		EnumAddressee recipientType = container.getCarrierType();
		setRecipient(recipientName, recipientType);
		setText();
		Keyboard.enableRepeatEvents(false);
		super.func_146281_b();
	}

	private void setFromSessionVars() {
		if (SessionVars.getStringVar("mail.letter.recipient") == null) {
			return;
		}

		String recipient = SessionVars.getStringVar("mail.letter.recipient");
		String typeName = SessionVars.getStringVar("mail.letter.addressee");

		if (StringUtils.isNotBlank(recipient) && StringUtils.isNotBlank(typeName)) {
			address.func_146180_a(recipient);

			EnumAddressee type = EnumAddressee.fromString(typeName);
			container.setCarrierType(type);
		}

		SessionVars.clearStringVar("mail.letter.recipient");
		SessionVars.clearStringVar("mail.letter.addressee");
	}

	private void setRecipient(String recipientName, EnumAddressee type) {
		if (this.isProcessedLetter || StringUtils.isBlank(recipientName)) {
			return;
		}

		PacketLetterInfoRequest packet = new PacketLetterInfoRequest(recipientName, type);
		NetworkUtil.sendToServer(packet);
	}

	@SideOnly(Side.CLIENT)
	private void setText() {
		if (this.isProcessedLetter) {
			return;
		}

		container.setText(this.text.func_146179_b());
	}

	@Override
	protected void addLedgers() {
		addErrorLedger(itemInventory);
		addHintLedger("letter");
	}
}
