/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http:www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.logic.crops;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;

import javax.annotation.Nullable;
import java.util.Map;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.core.config.Constants;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.plugins.PluginIC2;
import forestry.plugins.PluginTechReborn;

public class CropRubber extends CropDestroy {

	public CropRubber(World world, IBlockState blockState, BlockPos position) {
		super(world, blockState, position, getReplantState(blockState));
	}

	/**
	 * Convert a "wet" rubber log blockstate into the dry version.
	 * Total hack since we don't have access to the blockstates.
	 */
	private static <T extends Comparable<T>> IBlockState getReplantState(IBlockState sappyState) {
		if (hasRubberToHarvest(sappyState)) {
			for (Map.Entry<IProperty<?>, Comparable<?>> wetPropertyEntry : sappyState.func_177228_b().entrySet()) {
				String valueWetString = wetPropertyEntry.getValue().toString();
				String valueDryString = valueWetString.replace("wet", "dry");
				IProperty<?> property = wetPropertyEntry.getKey();
				if (property instanceof PropertyBool && property.func_177701_a().equals("hassap")) {
					return sappyState.func_177226_a(PropertyBool.func_177716_a("hassap"), false);
				}

				IBlockState baseState = sappyState.func_177230_c().func_176194_O().func_177621_b();
				IBlockState dryState = getStateWithValue(baseState, property, valueDryString);
				if (dryState != null) {
					return dryState;
				}
			}
		}

		return sappyState.func_177230_c().func_176223_P();
	}

	public static boolean hasRubberToHarvest(IBlockState blockState) {
		Block block = blockState.func_177230_c();
		if (PluginIC2.rubberWood != null && ItemStackUtil.equals(block, PluginIC2.rubberWood)) {
			ImmutableCollection<Comparable<?>> propertyValues = blockState.func_177228_b().values();
			for (Comparable<?> propertyValue : propertyValues) {
				if (propertyValue.toString().contains("wet")) {
					return true;
				}
			}
		} else if (PluginTechReborn.RUBBER_WOOD != null && ItemStackUtil.equals(block, PluginTechReborn.RUBBER_WOOD)) {
			return blockState.func_177229_b(PropertyBool.func_177716_a("hassap"));
		}
		return false;
	}

	@Nullable
	private static <T extends Comparable<T>> IBlockState getStateWithValue(IBlockState baseState, IProperty<T> property, String valueString) {
		Optional<T> value = property.func_185929_b(valueString);
		if (value.isPresent()) {
			return baseState.func_177226_a(property, value.get());
		}
		return null;
	}

	@Override
	protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
		NonNullList<ItemStack> harvested = NonNullList.func_191196_a();
		Block harvestBlock = world.func_180495_p(pos).func_177230_c();
		if (PluginIC2.rubberWood != null && ItemStackUtil.equals(harvestBlock, PluginIC2.rubberWood)) {
			harvested.add(PluginIC2.resin.func_77946_l());
		} else if (PluginTechReborn.RUBBER_WOOD != null && ItemStackUtil.equals(harvestBlock, PluginTechReborn.RUBBER_WOOD)) {
			harvested.add(PluginTechReborn.sap.func_77946_l());
		}
		PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
		NetworkUtil.sendNetworkPacket(packet, pos, world);

		world.func_180501_a(pos, replantState, Constants.FLAG_BLOCK_SYNC);
		return harvested;
	}

}
