package forestry.cultivation.blocks;

import java.util.Random;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.core.blocks.BlockBase;
import forestry.core.render.ParticleRender;
import forestry.cultivation.tiles.TilePlanter;

public class BlockPlanter extends BlockBase<BlockTypePlanter> {
	public static final PropertyBool MANUAL = PropertyBool.func_177716_a("manual");

	public BlockPlanter(BlockTypePlanter blockType) {
		super(blockType, Material.field_151575_d);
		this.func_180632_j(field_176227_L.func_177621_b().func_177226_a(FACING, EnumFacing.NORTH).func_177226_a(MANUAL, false));
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, FACING, MANUAL);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
		if (blockType == BlockTypePlanter.FARM_ENDER) {
			for (int i = 0; i < 3; ++i) {
				ParticleRender.addPortalFx(worldIn, pos, rand);
			}
		}
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		int facing = meta & 7;
		return func_176223_P().func_177226_a(FACING, EnumFacing.func_176733_a(facing)).func_177226_a(MANUAL, (meta & 8) == 8);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		if (state.func_177229_b(MANUAL)) {
			return 8 + state.func_177229_b(FACING).ordinal();
		}
		return state.func_177229_b(FACING).ordinal();
	}

	@Override
	public TileEntity createTileEntity(World world, IBlockState state) {
		TileEntity tile = super.func_149915_a(world, 0);
		if (tile instanceof TilePlanter) {
			TilePlanter planter = (TilePlanter) tile;
			planter.setManual(state.func_177229_b(MANUAL));
		}
		return tile;
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(MANUAL) ? 1 : 0;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new PlanterStateMapper());
	}

	@Override
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT;
	}

	@Override
	public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
		ItemStack stack = placer.func_184586_b(hand);
		return func_176223_P().func_177226_a(MANUAL, isManual(stack));
	}

	@Override
	public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
		for (byte i = 0; i < 2; i++) {
			items.add(get(i == 1));
		}
	}

	public static boolean isManual(ItemStack stack) {
		return stack.func_77960_j() == 1;
	}

	public ItemStack get(boolean isManual) {
		return new ItemStack(this, 1, isManual ? 1 : 0);
	}
}
