/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.multiblock;

import javax.annotation.Nullable;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

import com.mojang.authlib.GameProfile;

import forestry.api.core.ILocatable;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.PlayerUtil;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic> extends MultiblockTileEntityBase<T> implements ISidedInventory, IFilterSlotDelegate, ILocatable, IGuiHandlerTile {
	@Nullable
	private GameProfile owner;

	public MultiblockTileEntityForestry(T multiblockLogic) {
		super(multiblockLogic);
	}

	/**
	 * Called by a structure block when it is right clicked by a player.
	 */
	public void openGui(EntityPlayer player) {
		GuiHandler.openGui(player, this);
	}

	@Override
	public void func_145839_a(NBTTagCompound data) {
		super.func_145839_a(data);

		if (data.func_74764_b("owner")) {
			NBTTagCompound ownerNbt = data.func_74775_l("owner");
			this.owner = PlayerUtil.readGameProfileFromNBT(ownerNbt);
		}

		getInternalInventory().readFromNBT(data);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		data = super.func_189515_b(data);

		if (this.owner != null) {
			NBTTagCompound nbt = new NBTTagCompound();
			PlayerUtil.writeGameProfile(nbt, owner);
			data.func_74782_a("owner", nbt);
		}

		getInternalInventory().writeToNBT(data);
		return data;
	}

	/* INVENTORY */
	public IInventoryAdapter getInternalInventory() {
		return FakeInventoryAdapter.instance();
	}

	public boolean allowsAutomation() {
		return false;
	}

	@Override
	public boolean func_191420_l() {
		return getInternalInventory().func_191420_l();
	}

	@Override
	public final int func_70302_i_() {
		return getInternalInventory().func_70302_i_();
	}

	@Override
	public final ItemStack func_70301_a(int slotIndex) {
		return getInternalInventory().func_70301_a(slotIndex);
	}

	@Override
	public final ItemStack func_70298_a(int slotIndex, int amount) {
		return getInternalInventory().func_70298_a(slotIndex, amount);
	}

	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return getInternalInventory().func_70304_b(slotIndex);
	}

	@Override
	public final void func_70299_a(int slotIndex, ItemStack itemstack) {
		getInternalInventory().func_70299_a(slotIndex, itemstack);
	}

	@Override
	public final int func_70297_j_() {
		return getInternalInventory().func_70297_j_();
	}

	@Override
	public final void func_174889_b(EntityPlayer player) {
		getInternalInventory().func_174889_b(player);
	}

	@Override
	public final void func_174886_c(EntityPlayer player) {
		getInternalInventory().func_174886_c(player);
	}

	@Override
	public final String func_70005_c_() {
		return getInternalInventory().func_70005_c_();
	}

	@Override
	public ITextComponent func_145748_c_() {
		return getInternalInventory().func_145748_c_();
	}

	@Override
	public final boolean func_70300_a(EntityPlayer player) {
		return getInternalInventory().func_70300_a(player);
	}

	@Override
	public final boolean func_145818_k_() {
		return getInternalInventory().func_145818_k_();
	}

	@Override
	public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
		return getInternalInventory().func_94041_b(slotIndex, itemStack);
	}

	@Override
	public int[] func_180463_a(EnumFacing side) {
		if (allowsAutomation()) {
			return getInternalInventory().func_180463_a(side);
		} else {
			return Constants.SLOTS_NONE;
		}
	}

	@Override
	public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
		return allowsAutomation() && getInternalInventory().func_180462_a(slotIndex, itemStack, side);
	}

	@Override
	public final boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
		return allowsAutomation() && getInternalInventory().func_180461_b(slotIndex, itemStack, side);
	}

	@Override
	public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		return getInternalInventory().canSlotAccept(slotIndex, itemStack);
	}

	@Override
	public final boolean isLocked(int slotIndex) {
		return getInternalInventory().isLocked(slotIndex);
	}

	/* ILocatable */
	@Override
	public final World getWorldObj() {
		return field_145850_b;
	}

	/* IMultiblockComponent */

	@Override
	@Nullable
	public final GameProfile getOwner() {
		return owner;
	}

	public final void setOwner(GameProfile owner) {
		this.owner = owner;
	}

	/* Fields */
	@Override
	public int func_174887_a_(int id) {
		return getInternalInventory().func_174887_a_(id);
	}

	@Override
	public int func_174890_g() {
		return getInternalInventory().func_174890_g();
	}

	@Override
	public void func_174885_b(int id, int value) {
		getInternalInventory().func_174885_b(id, value);
	}

	@Override
	public void func_174888_l() {
		getInternalInventory().func_174888_l();
	}
}
