/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.entities;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class ParticleSnow extends Particle {
	public static final TextureAtlasSprite sprites[] = new TextureAtlasSprite[3];

	public ParticleSnow(World world, double x, double y, double z) {
		super(world, x, y, z, 0.0D, 0.0D, 0.0D);

		this.func_187117_a(sprites[field_187136_p.nextInt(sprites.length)]);
		this.field_70544_f *= 0.5F;
		this.field_70547_e = (int) (40.0D / (Math.random() * 0.8D + 0.2D));

		this.field_187129_i *= 0.01D;
		this.field_187130_j *= -0.4D;
		this.field_187131_k *= 0.01D;
	}

	@Override
	public int func_70537_b() {
		return 1;
	}

	@Override
	public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * partialTicks - field_70556_an;
		double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * partialTicks - field_70554_ao;
		double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * partialTicks - field_70555_ap;

		float minU = this.field_94054_b / 16.0F;
		float maxU = minU + 0.0624375F;
		float minV = this.field_94055_c / 16.0F;
		float maxV = minV + 0.0624375F;
		float scale = 0.1F * this.field_70544_f;

		if (this.field_187119_C != null) {
			minU = this.field_187119_C.func_94209_e();
			maxU = this.field_187119_C.func_94212_f();
			minV = this.field_187119_C.func_94206_g();
			maxV = this.field_187119_C.func_94210_h();
		}

		for (int i = 0; i < 5; i++) {
			renderParticle(buffer, x, y, z, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY, minU, maxU, minV, maxV, scale, partialTicks);
		}
	}

	private void renderParticle(BufferBuilder buffer, double x, double y, double z, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY, float minU, float maxU, float minV, float maxV, float scale, float timeStep) {
		int i = this.func_189214_a(timeStep);
		int j = i >> 16 & 65535;
		int k = i & 65535;
		buffer.func_181662_b(x - rotationX * scale - rotationYZ * scale, y - rotationXZ * scale, z - rotationZ * scale - rotationXY * scale).func_187315_a(maxU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b(x - rotationX * scale + rotationYZ * scale, y + rotationXZ * scale, z - rotationZ * scale + rotationXY * scale).func_187315_a(maxU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b(x + rotationX * scale + rotationYZ * scale, y + rotationXZ * scale, z + rotationZ * scale + rotationXY * scale).func_187315_a(minU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b(x + rotationX * scale - rotationYZ * scale, y - rotationXZ * scale, z + rotationZ * scale - rotationXY * scale).func_187315_a(minU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
	}
}
