package forestry.arboriculture.blocks;

import com.google.common.base.Preconditions;

import java.util.Collection;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.ModuleCharcoal;
import forestry.core.config.Config;

public class BlockWoodPile extends Block implements IItemModelRegister, IStateMapperRegister {

	public static final PropertyBool IS_ACTIVE = PropertyBool.func_177716_a("active");
	public static final PropertyInteger AGE = PropertyInteger.func_177719_a("age", 0, 7);
	public static final int RANDOM_TICK = 160;

	public BlockWoodPile() {
		super(Material.field_151575_d);
		func_149711_c(1.5f);
		func_149647_a(Tabs.tabArboriculture);
		func_149672_a(SoundType.field_185848_a);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, IS_ACTIVE, AGE);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(IS_ACTIVE) ? 8 + state.func_177229_b(AGE) : state.func_177229_b(AGE);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		boolean isActive = meta > 7;
		return func_176223_P().func_177226_a(IS_ACTIVE, isActive).func_177226_a(AGE, meta - (isActive ? 8 : 0));
	}

	@Override
	public int func_149738_a(World world) {
		return 960;
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149721_r(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149730_j(IBlockState state) {
		return false;
	}

	@Override
	public void func_176213_c(World world, BlockPos pos, IBlockState state) {
		if (!state.func_177229_b(IS_ACTIVE)) {
			for (EnumFacing facing : EnumFacing.field_82609_l) {
				IBlockState facingState = world.func_180495_p(pos.func_177972_a(facing));
				if (facingState.func_177230_c() == this && facingState.func_177229_b(IS_ACTIVE)) {
					world.func_175656_a(pos, state.func_177226_a(IS_ACTIVE, true));
					break;
				}
			}
		}
		world.func_175684_a(pos, this, this.func_149738_a(world) + world.field_73012_v.nextInt(RANDOM_TICK));
	}

	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos) {
		boolean isActive = state.func_177229_b(IS_ACTIVE);
		if (fromBlock == Blocks.field_150480_ab) {
			if (!isActive) {
				activatePile(state, world, pos, true);
			}
		}
	}

	private void activatePile(IBlockState state, World world, BlockPos pos, boolean scheduleUpdate) {
		world.func_180501_a(pos, state.func_177226_a(IS_ACTIVE, true), 2);
		if (scheduleUpdate) {
			world.func_175684_a(pos, this, (this.func_149738_a(world) + world.field_73012_v.nextInt(RANDOM_TICK)) / 4);
		}
	}

	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
		if (state.func_177229_b(IS_ACTIVE)) {
			for (EnumFacing facing : EnumFacing.field_82609_l) {
				BlockPos position = pos.func_177972_a(facing);
				if (!world.func_175667_e(position)) {
					continue;
				}
				IBlockState blockState = world.func_180495_p(position);
				Block block = blockState.func_177230_c();
				if (block == this) {
					if (!state.func_177229_b(IS_ACTIVE) && blockState.func_177229_b(IS_ACTIVE)) {
						activatePile(state, world, pos, false);
					} else if (!blockState.func_177229_b(IS_ACTIVE) && state.func_177229_b(IS_ACTIVE)) {
						activatePile(blockState, world, position, true);
					}
				} else if (world.func_175623_d(position) || !blockState.isSideSolid(world, position, facing.func_176734_d()) || block.isFlammable(world, position, facing.func_176734_d())) {
					world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
					return;
				}
			}
			if (rand.nextFloat() < 0.5F) {
				if (state.func_177229_b(AGE) < 7) {
					world.func_180501_a(pos, state.func_177226_a(AGE, state.func_177229_b(AGE) + 1), 2);
				} else {
					IBlockState ashState = ModuleCharcoal.getBlocks().getAshState(Math.round(Config.charcoalAmountBase + getCharcoalAmount(world, pos)));
					world.func_180501_a(pos, ashState, 2);
				}
			}
			world.func_175684_a(pos, this, this.func_149738_a(world) + world.field_73012_v.nextInt(RANDOM_TICK));
		}
	}

	@Override
	public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return 12;
	}

	@Override
	public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return true;
	}

	@Override
	public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return 25;
	}

	@Override
	public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
		if (state.func_177229_b(IS_ACTIVE)) {
			return 10;
		}
		return super.getLightValue(state, world, pos);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
		if (state.func_177229_b(IS_ACTIVE)) {
			if (rand.nextDouble() < 0.1D) {
				world.func_184134_a(pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0F + rand.nextFloat(), rand.nextFloat() * 0.7F + 0.3F, false);
			}
			float f = pos.func_177958_n() + 0.5F;
			float f1 = pos.func_177956_o() + 0.0F + rand.nextFloat() * 6.0F / 16.0F;
			float f2 = pos.func_177952_p() + 0.5F;
			float f3 = 0.52F;
			float f4 = rand.nextFloat() * 0.6F - 0.3F;
			if (rand.nextDouble() < 0.2D) {
				world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, f + f3 - 0.5, f1 + 1, f2 + f4, 0.0D, 0.15D, 0.0D);
			} else {
				world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, f + f3 - 0.5, f1 + 1, f2 + f4, 0.0D, 0.15D, 0.0D);
			}
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0);
	}

	private float getCharcoalAmount(World world, BlockPos pos) {
		float charcoalAmount = 0F;
		for (EnumFacing facing : EnumFacing.field_82609_l) {
			charcoalAmount += getCharcoalFaceAmount(world, pos, facing);
		}
		return Math.max(Math.min(charcoalAmount / 6, 63.0F - Config.charcoalAmountBase), -Config.charcoalAmountBase);
	}

	private int getCharcoalFaceAmount(World world, BlockPos pos, EnumFacing facing) {
		ICharcoalManager charcoalManager = Preconditions.checkNotNull(TreeManager.charcoalManager);
		Collection<ICharcoalPileWall> walls = charcoalManager.getWalls();

		BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos);
		testPos.func_189536_c(facing);
		int i = 0;
		while (i < Config.charcoalWallCheckRange && world.func_175667_e(testPos) && !world.func_175623_d(testPos)) {
			IBlockState state = world.func_180495_p(testPos);
			for (ICharcoalPileWall wall : walls) {
				if (wall.matches(state)) {
					return wall.getCharcoalAmount();
				}
			}
			testPos.func_189536_c(facing);
			i++;
		}
		return 0;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new StateMap.Builder().func_178442_a(AGE, IS_ACTIVE).func_178441_a());
	}

}
