/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.genetics.alleles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;

public class AlleleEffectResurrection extends AlleleEffectThrottled {

	public static class Resurrectable {
		public final ItemStack res;
		public final Class<? extends EntityLiving> risen;
		public final Optional<Consumer<EntityLiving>> risenTransformer;

		public Resurrectable(ItemStack res, Class<? extends EntityLiving> risen) {
			this.res = res;
			this.risen = risen;
			this.risenTransformer = Optional.empty();
		}

		public <E extends EntityLiving> Resurrectable(ItemStack res, Class<E> risen, Consumer<E> risenTransformer) {
			this.res = res;
			this.risen = risen;
			this.risenTransformer = Optional.of((Consumer<EntityLiving>) risenTransformer);
		}
	}

	public static List<Resurrectable> getReanimationList() {
		ArrayList<Resurrectable> list = new ArrayList<>();
		list.add(new Resurrectable(new ItemStack(Items.field_151103_aS), EntitySkeleton.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151032_g), EntitySkeleton.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151078_bh), EntityZombie.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151072_bj), EntityBlaze.class));
		return list;
	}

	public static List<Resurrectable> getResurrectionList() {
		ArrayList<Resurrectable> list = new ArrayList<>();
		list.add(new Resurrectable(new ItemStack(Items.field_151016_H), EntityCreeper.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151079_bi), EntityEnderman.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151007_F), EntitySpider.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151070_bp), EntitySpider.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151007_F), EntityCaveSpider.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151070_bp), EntityCaveSpider.class));
		list.add(new Resurrectable(new ItemStack(Items.field_151073_bk), EntityGhast.class));
		list.add(new Resurrectable(new ItemStack(Blocks.field_150380_bt), EntityDragon.class, dragon -> dragon.func_184670_cT().func_188758_a(PhaseList.field_188741_a)));
		return list;
	}

	private final List<Resurrectable> resurrectables;

	public AlleleEffectResurrection(String name, List<Resurrectable> resurrectables) {
		super(name, true, 40, true, true);
		this.resurrectables = resurrectables;
	}

	@Override
	public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
		List<EntityItem> entities = getEntitiesInRange(genome, housing, EntityItem.class);
		if (entities.isEmpty()) {
			return storedData;
		}

		Collections.shuffle(resurrectables);

		for (EntityItem entity : entities) {
			if (resurrectEntity(entity)) {
				break;
			}
		}

		return storedData;
	}

	private boolean resurrectEntity(EntityItem entity) {
		if (entity.field_70128_L) {
			return false;
		}

		ItemStack contained = entity.func_92059_d();
		for (Resurrectable entry : resurrectables) {
			if (ItemStackUtil.isIdenticalItem(entry.res, contained)) {
				EntityLiving spawnedEntity = EntityUtil.spawnEntity(entity.field_70170_p, entry.risen, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
				if (spawnedEntity != null) {
					entry.risenTransformer.ifPresent(transformer -> transformer.accept(spawnedEntity));
				}

				contained.func_190918_g(1);

				if (contained.func_190916_E() <= 0) {
					entity.func_70106_y();
				}

				return true;
			}
		}

		return false;
	}
}
