/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.api.farming.ISoil;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.Soil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public final class FarmProperties
implements IFarmProperties {
    private final Set<ISoil> soils = new HashSet<ISoil>();
    private final Set<String> farmablesIdentifiers;
    private final IFarmLogic manualLogic;
    private final IFarmLogic managedLogic;
    private final IFarmableInfo defaultInfo;
    @Nullable
    private Collection<IFarmable> farmables;
    @Nullable
    private Collection<IFarmableInfo> farmableInfo;

    public FarmProperties(BiFunction<IFarmProperties, Boolean, IFarmLogic> logicFactory, Set<String> farmablesIdentifiers, String identifier) {
        this.farmablesIdentifiers = farmablesIdentifiers;
        this.manualLogic = logicFactory.apply(this, true);
        this.managedLogic = logicFactory.apply(this, false);
        this.defaultInfo = FarmRegistry.getInstance().getFarmableInfo(identifier);
    }

    @Override
    public void registerFarmables(String identifier) {
        this.farmablesIdentifiers.add(identifier);
    }

    @Override
    public Collection<IFarmable> getFarmables() {
        if (this.farmables == null) {
            this.farmables = this.farmablesIdentifiers.stream().map(FarmRegistry.getInstance()::getFarmables).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return this.farmables;
    }

    @Override
    public Collection<IFarmableInfo> getFarmableInfo() {
        if (this.farmableInfo == null) {
            this.farmableInfo = this.farmablesIdentifiers.stream().map(FarmRegistry.getInstance()::getFarmableInfo).collect(Collectors.toSet());
        }
        return this.farmableInfo;
    }

    @Override
    public IFarmLogic getLogic(boolean manuel) {
        return manuel ? this.manualLogic : this.managedLogic;
    }

    @Override
    public void registerSoil(ItemStack resource, IBlockState soilState, boolean hasMetaData) {
        this.soils.add(new Soil(resource, soilState, hasMetaData));
    }

    @Override
    public void addGermlings(ItemStack ... germlings) {
        this.defaultInfo.addGermlings(germlings);
    }

    @Override
    public void addGermlings(Collection<ItemStack> germlings) {
        this.defaultInfo.addGermlings(germlings);
    }

    @Override
    public void addProducts(ItemStack ... products) {
        this.defaultInfo.addProducts(products);
    }

    @Override
    public void addProducts(Collection<ItemStack> products) {
        this.defaultInfo.addProducts(products);
    }

    @Override
    public boolean isAcceptedSoil(IBlockState ground) {
        for (ISoil soil : this.soils) {
            IBlockState soilState = soil.getSoilState();
            Block soilBlock = soilState.func_177230_c();
            Block block = ground.func_177230_c();
            if (soilState.func_177230_c() != ground.func_177230_c() || soil.hasMetaData() && block.func_176201_c(ground) != soilBlock.func_176201_c(soilState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        for (ISoil soil : this.soils) {
            ItemStack resource = soil.getResource();
            if (!resource.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ISoil> getSoils() {
        return this.soils;
    }
}

