/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import forestry.core.utils.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class JsonUtil {
    private JsonUtil() {
    }

    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback) {
        return JsonUtil.deserializeItemStack(object, fallback, false);
    }

    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback, boolean logError) {
        if (!object.has("item")) {
            if (logError) {
                Log.error("Unsupported icon type, currently only items are supported (add 'item' key)", new Object[0]);
            }
            return fallback;
        }
        try {
            Item item = JsonUtils.func_188180_i((JsonObject)object, (String)"item");
            int meta = JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0);
            ItemStack stack = new ItemStack(item, 1, meta);
            stack.func_77982_d(net.minecraftforge.common.util.JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
            return stack;
        }
        catch (JsonSyntaxException e) {
            if (logError) {
                Log.trace("Filed to parse item.", new Object[]{e});
            }
            return fallback;
        }
    }
}

