/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.MoreObjects;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.ITooltipSupplier;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.ElementEvent;
import forestry.api.gui.events.GuiElementEvent;
import forestry.api.gui.events.GuiEventDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElement
extends Gui
implements IGuiElement {
    private final List<ITooltipSupplier> tooltipSuppliers = new ArrayList<ITooltipSupplier>();
    private final Collection<Consumer<? extends GuiElementEvent>> eventHandlers = new ArrayList<Consumer<? extends GuiElementEvent>>();
    protected int xPos;
    protected int yPos;
    protected int xOffset;
    protected int yOffset;
    protected int width;
    protected int height;
    protected int cropX;
    protected int cropY;
    protected int cropWidth = -1;
    protected int cropHeight = -1;
    @Nullable
    protected IGuiElement cropElement = null;
    private GuiElementAlignment align = GuiElementAlignment.TOP_LEFT;
    protected boolean visible = true;
    @Nullable
    protected IGuiElement parent;

    public GuiElement(int width, int height) {
        this(0, 0, width, height);
    }

    public GuiElement(int xPos, int yPos, int width, int height) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
    }

    @Override
    public void onCreation() {
    }

    @Override
    public void onDeletion() {
        IWindowElement window = this.getWindow();
        window.postEvent(new ElementEvent.Deletion(this), GuiEventDestination.ALL);
    }

    @Override
    public final int getX() {
        int x = 0;
        int parentWidth = this.parent != null ? this.parent.getWidth() : -1;
        int w = this.getWidth();
        if (parentWidth >= 0 && parentWidth > w) {
            x = (int)((float)(parentWidth - w) * this.align.getXOffset());
        }
        return this.xPos + x + this.xOffset;
    }

    @Override
    public final int getY() {
        int y = 0;
        int parentHeight = this.parent != null ? this.parent.getHeight() : -1;
        int h = this.getHeight();
        if (parentHeight >= 0 && parentHeight > h) {
            y = (int)((float)(parentHeight - h) * this.align.getYOffset());
        }
        return this.yPos + y + this.yOffset;
    }

    @Override
    public final int getAbsoluteX() {
        return this.parent == null ? this.getX() : this.getX() + this.parent.getAbsoluteX();
    }

    @Override
    public final int getAbsoluteY() {
        return this.parent == null ? this.getY() : this.getY() + this.parent.getAbsoluteY();
    }

    @Override
    public final void draw(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        if (this.isCropped()) {
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            double scaleWidth = (double)mc.field_71443_c / res.func_78327_c();
            double scaleHeight = (double)mc.field_71440_d / res.func_78324_d();
            IGuiElement cropRelative = this.cropElement != null ? this.cropElement : this;
            int posX = cropRelative.getAbsoluteX();
            int posY = cropRelative.getAbsoluteY();
            GL11.glScissor((int)((int)((double)(posX + this.cropX) * scaleWidth)), (int)((int)((double)mc.field_71440_d - (double)(posY + this.cropY + this.cropHeight) * scaleHeight)), (int)((int)((double)this.cropWidth * scaleWidth)), (int)((int)((double)this.cropHeight * scaleHeight)));
        }
        this.drawElement(mouseX, mouseY);
        if (this.isCropped()) {
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.setSize(this.width, height);
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.height);
    }

    @Override
    public IGuiElement setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public IGuiElement setOffset(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        return this;
    }

    @Override
    public void setXPosition(int xPos) {
        this.setLocation(xPos, this.yPos);
    }

    @Override
    public void setYPosition(int yPos) {
        this.setLocation(this.xPos, yPos);
    }

    @Override
    public IGuiElement setLocation(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        return this;
    }

    @Override
    public IGuiElement setBounds(int xPos, int yPos, int width, int height) {
        this.setLocation(xPos, yPos);
        this.setSize(width, height);
        return this;
    }

    @Override
    public IGuiElement setAlign(GuiElementAlignment align) {
        this.align = align;
        return this;
    }

    @Override
    public GuiElementAlignment getAlign() {
        return this.align;
    }

    @Override
    public void setCroppedZone(@Nullable IGuiElement cropElement, int cropX, int cropY, int cropWidth, int cropHeight) {
        this.cropElement = cropElement;
        this.cropX = cropX;
        this.cropY = cropY;
        this.cropWidth = cropWidth;
        this.cropHeight = cropHeight;
    }

    @Override
    @Nullable
    public IGuiElement getCropElement() {
        return this.cropElement;
    }

    @Override
    public int getCropX() {
        return this.cropX;
    }

    @Override
    public int getCropY() {
        return this.cropY;
    }

    @Override
    public int getCropWidth() {
        return this.cropWidth;
    }

    @Override
    public int getCropHeight() {
        return this.cropHeight;
    }

    @Override
    public boolean isCropped() {
        return this.cropElement != null && this.cropWidth >= 0 && this.cropHeight >= 0;
    }

    @Override
    public IWindowElement getWindow() {
        if (this.parent == null) {
            throw new IllegalStateException("Tried to access the window element of an element that doesn't had one.");
        }
        return this.parent.getWindow();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return false;
        }
        return mouseX >= 0 && mouseX < this.getWidth() && mouseY >= 0 && mouseY < this.getHeight();
    }

    @Override
    public final boolean isMouseOver() {
        IWindowElement window = this.getWindow();
        int mouseX = window.getRelativeMouseX(this);
        int mouseY = window.getRelativeMouseY(this);
        if (!this.isCropped()) {
            return this.isMouseOver(mouseX, mouseY);
        }
        IGuiElement cropRelative = this.cropElement != null ? this.cropElement : this;
        int posX = cropRelative.getAbsoluteX() - this.getAbsoluteX();
        int posY = cropRelative.getAbsoluteY() - this.getAbsoluteY();
        boolean inCrop = mouseX >= posX && mouseY >= posY && mouseX <= posX + this.cropWidth && mouseY <= posY + this.cropHeight;
        return inCrop && this.isMouseOver(mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    protected void onUpdateClient() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.onUpdateClient();
    }

    @Override
    public boolean isVisible() {
        return this.visible && (this.parent == null || this.parent.isVisible());
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    @Override
    public boolean isEnabled() {
        return this.parent == null || this.parent.isEnabled();
    }

    @Override
    @Nullable
    public IGuiElement getParent() {
        return this.parent;
    }

    @Override
    public IGuiElement setParent(@Nullable IGuiElement parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        ArrayList<String> lines = new ArrayList<String>();
        this.tooltipSuppliers.stream().filter(ITooltipSupplier::hasTooltip).forEach(supplier -> supplier.addTooltip(lines, this, mouseX, mouseY));
        return lines;
    }

    @Override
    public IGuiElement addTooltip(String line) {
        this.addTooltip((Collection<String> tooltipLines, IGuiElement element, int mouseX, int mouseY) -> tooltipLines.add(line));
        return this;
    }

    @Override
    public IGuiElement addTooltip(Collection<String> lines) {
        this.addTooltip((Collection<String> tooltipLines, IGuiElement element, int mouseX, int mouseY) -> tooltipLines.addAll(lines));
        return this;
    }

    @Override
    public IGuiElement addTooltip(ITooltipSupplier supplier) {
        this.tooltipSuppliers.add(supplier);
        return this;
    }

    @Override
    public boolean hasTooltip() {
        return !this.tooltipSuppliers.isEmpty();
    }

    @Override
    public void clearTooltip() {
        this.tooltipSuppliers.clear();
    }

    @Override
    public List<String> getTooltip() {
        int mouseX = this.getWindow().getRelativeMouseX(this);
        int mouseY = this.getWindow().getRelativeMouseY(this);
        ArrayList<String> lines = new ArrayList<String>();
        this.tooltipSuppliers.stream().filter(ITooltipSupplier::hasTooltip).forEach(supplier -> supplier.addTooltip(lines, this, mouseX, mouseY));
        return lines;
    }

    @Override
    public <E extends GuiElementEvent> void addEventHandler(Consumer<E> eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    @Override
    public void receiveEvent(GuiElementEvent event) {
        for (Consumer<? extends GuiElementEvent> eventHandler : this.eventHandlers) {
            eventHandler.accept(event);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("w", this.width).add("h", this.height).add("a", (Object)this.align).add("v", this.isVisible()).add("xO", this.xOffset).add("yO", this.yOffset).toString();
    }
}

