package forestry.farming.logic.crops;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.event.ForgeEventFactory;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;

public class CropChorusFlower extends Crop {
	private static final IBlockState BLOCK_STATE = Blocks.field_185766_cS.func_176223_P();

	public CropChorusFlower(World world, BlockPos position) {
		super(world, position);
	}

	@Override
	protected boolean isCrop(World world, BlockPos pos) {
		return world.func_180495_p(pos).func_177230_c() == Blocks.field_185766_cS;
	}

	@Override
	protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
		NonNullList<ItemStack> harvested = NonNullList.func_191196_a();
		harvested.add(new ItemStack(Blocks.field_185766_cS));
		float chance = ForgeEventFactory.fireBlockHarvesting(harvested, world, pos, BLOCK_STATE, 0, 1.0F, false, null);

		harvested.removeIf(next -> world.field_73012_v.nextFloat() > chance);

		PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, BLOCK_STATE);
		NetworkUtil.sendNetworkPacket(packet, pos, world);

		world.func_175698_g(pos);

		return harvested;
	}
}
