package forestry.cultivation.tiles;

import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import forestry.farming.logic.ForestryFarmIdentifier;

public class TileFarmMushroom extends TilePlanter {
	public TileFarmMushroom() {
		super(ForestryFarmIdentifier.SHROOM);
	}

	@Override
	public NonNullList<ItemStack> createGermlingStacks() {
		return createList(
			new ItemStack(Blocks.field_150337_Q),
			new ItemStack(Blocks.field_150338_P),
			new ItemStack(Blocks.field_150338_P),
			new ItemStack(Blocks.field_150337_Q)
		);
	}

	@Override
	public NonNullList<ItemStack> createResourceStacks() {
		return createList(
			new ItemStack(Blocks.field_150391_bh),
			new ItemStack(Blocks.field_150346_d, 1, 2),
			new ItemStack(Blocks.field_150346_d, 1, 2),
			new ItemStack(Blocks.field_150391_bh)
		);
	}

	@Override
	public NonNullList<ItemStack> createProductionStacks() {
		return createList(
			new ItemStack(Blocks.field_150337_Q),
			new ItemStack(Blocks.field_150338_P),
			new ItemStack(Blocks.field_150338_P),
			new ItemStack(Blocks.field_150337_Q)
		);
	}
}
