package forestry.core.utils;

import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTooltipUtil {
	@SideOnly(Side.CLIENT)
	public static void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
		String unlocalizedName = stack.func_77977_a();
		String tooltipKey = unlocalizedName + ".tooltip";
		if (Translator.canTranslateToLocal(tooltipKey)) {
			String tooltipInfo = Translator.translateToLocal(tooltipKey);
			Minecraft minecraft = Minecraft.func_71410_x();
			List<String> tooltipInfoWrapped = minecraft.field_71466_p.func_78271_c(tooltipInfo, 150);
			tooltip.addAll(tooltipInfoWrapped);
		}
	}

	@SideOnly(Side.CLIENT)
	public static void addShiftInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
		tooltip.add(TextFormatting.ITALIC .toString() + '<' + Translator.translateToLocal("for.gui.tooltip.tmi") + '>');
	}

	@SideOnly(Side.CLIENT)
	public static List<String> getInformation(ItemStack stack){
		Minecraft minecraft = Minecraft.func_71410_x();
		boolean advancedTooltips = minecraft.field_71474_y.field_82882_x;
		return getInformation(stack, minecraft.field_71439_g, advancedTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL);
	}

	@SideOnly(Side.CLIENT)
	public static List<String> getInformation(ItemStack stack, EntityPlayer player, ITooltipFlag flag){
		if (stack.func_190926_b()) {
			return Collections.emptyList();
		}
		List<String> tooltip = stack.func_82840_a(player, flag);
		for (int i = 0; i < tooltip.size(); ++i) {
			if (i == 0) {
				tooltip.set(i, stack.func_77953_t().field_77937_e + tooltip.get(i));
			} else {
				tooltip.set(i, TextFormatting.GRAY + tooltip.get(i));
			}
		}
		return tooltip;
	}
}
