package forestry.arboriculture.items;

import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;

import forestry.api.arboriculture.IWoodType;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.BlockForestrySlab;

public class ItemBlockWoodSlab extends ItemSlab {
	public ItemBlockWoodSlab(BlockForestrySlab block, BlockForestrySlab slab, BlockForestrySlab doubleSlab) {
		super(block, slab, doubleSlab);
	}

	@Override
	public String func_77653_i(ItemStack itemstack) {
		BlockForestrySlab<?> wood = (BlockForestrySlab) func_179223_d();
		int meta = itemstack.func_77960_j();
		IWoodType woodType = wood.getWoodType(meta);
		return WoodHelper.getDisplayName(wood, woodType);
	}

	@Override
	public int getItemBurnTime(ItemStack itemStack) {
		BlockForestrySlab forestrySlab = (BlockForestrySlab) this.field_150939_a;
		if (forestrySlab.isFireproof()) {
			return 0;
		} else {
			return 150;
		}
	}
}
