/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.ModelManager;
import forestry.core.utils.ModelUtil;
import forestry.storage.items.ItemCrated;
import forestry.storage.models.ModelCrateBaked;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCrate
implements IModel {
    private static final String CUSTOM_CRATES = "forestry:item/crates/";
    private static List<BakedQuad> bakedQuads = new LinkedList<BakedQuad>();
    private final ItemCrated crated;
    private final ItemStack contained;

    ModelCrate(ItemCrated crated) {
        this.crated = crated;
        this.contained = crated.getContained();
    }

    @Nullable
    private IBakedModel getCustomContentModel() {
        IModel model;
        ResourceLocation registryName = this.crated.getRegistryName();
        if (registryName == null) {
            return null;
        }
        String containedName = registryName.func_110623_a().replace("crated.", "");
        ResourceLocation location = new ResourceLocation(CUSTOM_CRATES + containedName);
        if (!ModelUtil.resourceExists(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"))) {
            return null;
        }
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)location);
        }
        catch (Exception e) {
            return null;
        }
        return model.bake(ModelManager.getInstance().getDefaultItemState(), DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ModelCrateBaked model;
        if (bakedQuads.isEmpty()) {
            IModel crateModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("forestry:item/crate-filled"));
            IBakedModel bakedModel = crateModel.bake(ModelManager.getInstance().getDefaultItemState(), DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE);
            for (BakedQuad quad : bakedModel.func_188616_a(null, null, 0L)) {
                bakedQuads.add(new BakedQuad(quad.func_178209_a(), 100, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
            }
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(bakedQuads);
        IBakedModel contentModel = this.getCustomContentModel();
        if (contentModel == null) {
            model = new ModelCrateBaked(quads, this.contained);
        } else {
            quads.addAll(contentModel.func_188616_a(null, null, 0L));
            model = new ModelCrateBaked(quads);
        }
        return new PerspectiveMapWrapper((IBakedModel)model, ModelManager.getInstance().getDefaultItemState());
    }
}

