/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.owner;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnerHandler;
import forestry.core.utils.PlayerUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class OwnerHandler
implements IOwnerHandler,
IStreamable,
INbtWritable,
INbtReadable {
    @Nullable
    private GameProfile owner = null;

    @Override
    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        if (this.owner == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.func_180714_a(this.owner.getName());
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        if (data.readBoolean()) {
            GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readString());
            this.setOwner(owner);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        GameProfile owner;
        if (data.func_74764_b("owner") && (owner = PlayerUtil.readGameProfileFromNBT(data.func_74775_l("owner"))) != null) {
            this.setOwner(owner);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        return data;
    }
}

