/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui.elements;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.climatology.gui.GuiHabitatFormer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClimateBarElement
extends GuiElement {
    public static final float MAX_VALUE = 2.0f;
    private final IClimateTransformer transformer;
    private final ClimateType type;
    private boolean dragging;

    public ClimateBarElement(int xPos, int yPos, IClimateTransformer transformer, ClimateType type) {
        super(xPos, yPos, 52, 12);
        this.transformer = transformer;
        this.type = type;
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            if (GuiScreen.func_146271_m()) {
                GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
                IClimateState climateState = former.getClimate();
                IClimateState newState = climateState.toImmutable().setClimate(type, transformer.getDefault().getTemperature());
                former.setClimate(newState);
                former.sendClimateUpdate();
                return;
            }
            this.dragging = true;
            this.handleMouse(event.getRelativeX(), event.getRelativeY());
        });
        this.addSelfEventHandler(GuiEvent.UpEvent.class, event -> {
            if (this.dragging) {
                this.dragging = false;
                GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
                former.sendClimateUpdate();
            }
        });
        this.addTooltip((Collection<String> tooltip, IGuiElement element, int mouseX, int mouseY) -> {
            IClimateState targetedState = transformer.getTarget();
            IClimateState state = transformer.getCurrent();
            IClimateState defaultState = transformer.getDefault();
            tooltip.add(Translator.translateToLocalFormatted("for.gui.habitat_former.climate.target", StringUtil.floatAsPercent(targetedState.getClimate(type))));
            tooltip.add(Translator.translateToLocalFormatted("for.gui.habitat_former.climate.value", StringUtil.floatAsPercent(state.getClimate(type))));
            tooltip.add(Translator.translateToLocalFormatted("for.gui.habitat_former.climate.default", StringUtil.floatAsPercent(defaultState.getClimate(type))));
        });
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        this.handleMouse(mouseX - this.getX(), mouseY - this.getY());
        GlStateManager.func_179141_d();
        GuiHabitatFormer gui = (GuiHabitatFormer)this.getWindow().getGui();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(gui.textureFile);
        ClimateBarElement.setGLColorFromInt(this.type == ClimateType.TEMPERATURE ? 16766720 : 0x7FF4F4);
        int progressScaled = this.getProgressScaled();
        this.func_73729_b(1, 1, 177, 69, progressScaled, 10);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(1 + this.getDefaultPosition(), 1, 232 + (this.type == ClimateType.TEMPERATURE ? 3 : 0), 69, 1, 10);
        this.func_73729_b(1 + this.getPointerPosition(), 1, 229, 69, 1, 10);
        this.func_73729_b(1, 1, 177, 80, 50, 10);
        GlStateManager.func_179118_c();
    }

    private int getProgressScaled() {
        float value = this.transformer.getCurrent().getClimate(this.type);
        return (int)(value * (float)(this.width - 2) / 2.0f);
    }

    private int getPointerPosition() {
        float targetedValue = this.transformer.getTarget().getClimate(this.type);
        return (int)(targetedValue * 49.0f / 2.0f);
    }

    private int getDefaultPosition() {
        float value = this.transformer.getDefault().getClimate(this.type);
        return (int)(value * 49.0f / 2.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private void handleMouse(int mouseX, int mouseY) {
        if (!this.dragging) {
            return;
        }
        if (mouseX < 1 || mouseY < 1 || mouseX > this.width - 1 || mouseY > this.height - 1) {
            return;
        }
        float quotient = MathHelper.func_76131_a((float)((float)(mouseX - 1) / (float)(this.width - 3)), (float)0.0f, (float)1.0f);
        float value = 2.0f * quotient;
        GuiHabitatFormer former = (GuiHabitatFormer)this.getWindow().getGui();
        IClimateState climateState = former.getClimate();
        IClimateState newState = climateState.toImmutable().setClimate(this.type, value);
        former.setClimate(newState);
    }
}

