package forestry.sorting.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

import forestry.sorting.tiles.TileGeneticFilter;

public class ItemHandlerFilter implements IItemHandler {
	private final TileGeneticFilter filter;
	private final IItemHandler itemHandler;
	private final EnumFacing facing;

	public ItemHandlerFilter(TileGeneticFilter filter, EnumFacing facing) {
		this.filter = filter;
		this.facing = facing;
		this.itemHandler = new InvWrapper(filter);
	}

	@Override
	public int getSlots() {
		return 1;
	}

	@Override
	public ItemStack getStackInSlot(int slot) {
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
		ItemStack remaining = stack;
		for (EnumFacing facing : filter.getValidDirections(stack, facing)) {
			remaining = itemHandler.insertItem(facing.func_176745_a(), stack, simulate);
			if (remaining.func_190926_b()) {
				return ItemStack.field_190927_a;
			}
		}
		return remaining;
	}

	@Override
	public ItemStack extractItem(int slot, int amount, boolean simulate) {
		return ItemStack.field_190927_a;
	}

	@Override
	public int getSlotLimit(int slot) {
		return 64;
	}
}
