package forestry.sorting.gui;

import javax.annotation.Nullable;
import java.io.IOException;

import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

import forestry.api.genetics.IFilterLogic;
import forestry.core.config.Constants;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.widgets.RuleWidget;
import forestry.sorting.gui.widgets.SelectionWidget;
import forestry.sorting.gui.widgets.SpeciesWidget;
import forestry.sorting.tiles.IFilterContainer;

public class GuiGeneticFilter extends GuiForestryTitled<ContainerGeneticFilter> {

	private final IFilterContainer tile;
	private final WidgetScrollBar scrollBar;
	public final SelectionWidget selection;
	@Nullable
	private GuiTextField searchField;

	public GuiGeneticFilter(IFilterContainer tile, InventoryPlayer inventory) {
		super(Constants.TEXTURE_PATH_GUI + "/filter.png", new ContainerGeneticFilter(tile, inventory), tile);
		field_147000_g = 222;
		field_146999_f = 212;
		this.tile = tile;

		for (int i = 0; i < 6; i++) {
			EnumFacing facing = EnumFacing.func_82600_a(i);
			widgetManager.add(new RuleWidget(widgetManager, 8 + 36, 18 + i * 18, facing, this));
		}

		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 3; j++) {
				for (int k = 0; k < 2; k++) {
					widgetManager.add(new SpeciesWidget(widgetManager, 44 + 36 + j * 45 + k * 18, 18 + i * 18, EnumFacing.func_82600_a(i), j, k == 0, this));
				}
			}
		}

		this.scrollBar = new WidgetScrollBar(widgetManager, 157 + 36, 150, 12, 64, new Drawable(new ResourceLocation(Constants.TEXTURE_PATH_GUI + "/container/creative_inventory/tabs.png"), 232, 0, 12, 15));
		widgetManager.add(this.selection = new SelectionWidget(widgetManager, 0, 134, scrollBar, this));
		widgetManager.add(scrollBar);
		scrollBar.setVisible(false);
	}

	public <S> void onModuleClick(ISelectableProvider<S> provider) {
		if (selection.isSame(provider)) {
			deselectFilter();
		} else {
			selectFilter(provider);
		}
	}

	private <S> void selectFilter(ISelectableProvider<S> provider) {
		selection.setProvider(provider);
		if (searchField != null) {
			searchField.func_146184_c(true);
			searchField.func_146189_e(true);
		}
		selection.filterEntries(searchField != null ? searchField.func_146179_b() : "");
		for (Slot slot : field_147002_h.field_75151_b) {
			if (slot instanceof SlotGeneticFilter) {
				SlotGeneticFilter filter = (SlotGeneticFilter) slot;
				filter.setEnabled(false);
			}
		}
	}

	private void deselectFilter() {
		this.selection.setProvider(null);
		if (searchField != null) {
			searchField.func_146184_c(false);
			searchField.func_146189_e(false);
		}
		scrollBar.setVisible(false);
		for (Slot slot : field_147002_h.field_75151_b) {
			if (slot instanceof SlotGeneticFilter) {
				SlotGeneticFilter filter = (SlotGeneticFilter) slot;
				filter.setEnabled(true);
			}
		}
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		String oldString = searchField != null ? searchField.func_146179_b() : "";

		this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + selection.getX() + 89 + 36, selection.getY() + this.field_147009_r + 4, 80, this.field_146289_q.field_78288_b);
		this.searchField.func_146203_f(50);
		this.searchField.func_146185_a(false);
		this.searchField.func_146193_g(16777215);
		this.searchField.func_146180_a(oldString);
	}

	@Override
	protected void func_146976_a(float f, int mouseX, int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);

		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		GlStateManager.func_179140_f();
		if (searchField != null) {
			this.searchField.func_146194_f();
		}
	}

	@Override
	protected void func_73869_a(char typedChar, int keyCode) throws IOException {
		if (searchField != null && this.searchField.func_146201_a(typedChar, keyCode)) {
			scrollBar.setValue(0);
			selection.filterEntries(searchField.func_146179_b());
		} else {
			super.func_73869_a(typedChar, keyCode);
		}
	}

	@Nullable
	@Override
	protected Slot getSlotAtPosition(int mouseX, int mouseY) {
		Slot slot = super.getSlotAtPosition(mouseX, mouseY);
		if (slot instanceof SlotGeneticFilter && selection.getLogic() != null) {
			return null;
		}
		return slot;
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.func_73864_a(mouseX, mouseY, mouseButton);

		if (searchField != null) {
			searchField.func_146192_a(mouseX, mouseY, mouseButton);
		}
		Widget widget = widgetManager.getAtPosition(mouseX - field_147003_i, mouseY - field_147009_r);
		if (widget == null) {
			deselectFilter();
		}
	}

	@Override
	protected void addLedgers() {
		addHintLedger("filter");
	}

	public IFilterContainer getContainer() {
		return tile;
	}

	public IFilterLogic getLogic(){
		return tile.getLogic();
	}
}
