package forestry.core.capabilities;

import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

import net.minecraftforge.fml.common.Optional;

import forestry.core.config.Constants;
import forestry.core.tiles.TilePowered;

import buildcraft.api.tiles.IHasWork;

@Optional.Interface(iface = "buildcraft.api.tiles.IHasWork", modid = Constants.BCLIB_MOD_ID)
public class HasWorkWrapper implements IHasWork {

	@CapabilityInject(IHasWork.class)
	public static Capability<IHasWork> CAPABILITY_HAS_WORK;

	private final TilePowered self;

	public HasWorkWrapper(TilePowered self) {
		this.self = self;
	}

	@Override
	public boolean hasWork() {
		return self.hasWork();
	}

}
