/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@ForestryModule(containerID="forestry_compat", moduleID="mysticalagriculture", name="Mystical Agriculture", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.mysticalagriculture.description")
public class PluginMysticalAgriculture
extends CompatPlugin {
    private static final String MAGICAL_AGRICULTURE = "mysticalagriculture";

    public PluginMysticalAgriculture() {
        super("Mystical Agriculture", MAGICAL_AGRICULTURE);
    }

    @Override
    public void registerRecipes() {
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            ImmutableList crops = ImmutableList.of((Object)"stone", (Object)"dirt", (Object)"nature", (Object)"wood", (Object)"water", (Object)"ice", (Object)"fire", (Object)"dye", (Object)"nether", (Object)"coal", (Object)"iron", (Object)"nether_quartz", (Object[])new String[]{"glowstone", "redstone", "obsidian", "gold", "lapis_lazuli", "end", "experience", "diamond", "emerald", "zombie", "pig", "chicken", "cow", "sheep", "slime", "skeleton", "creeper", "spider", "rabbit", "guardian", "blaze", "ghast", "enderman", "wither_skeleton", "rubber", "silicon", "sulfur", "aluminum", "copper", "saltpeter", "tin", "bronze", "zinc", "brass", "silver", "lead", "steel", "nickel", "constantan", "electrum", "invar", "mithril", "tungsten", "titanium", "chrome", "platinum", "iridium", "ruby", "sapphire", "peridot", "amber", "topaz", "malachite", "tanzanite", "blizz", "blitz", "basalz", "signalum", "lumium", "enderium", "aluminum_brass", "knightslime", "ardite", "cobalt", "manyullyn", "electrical_steel", "redstone_alloy", "conductive_iron", "soularium", "dark_steel", "pulsating_iron", "energetic_alloy", "vibrant_alloy", "mystical_flower", "manasteel", "terrasteel", "osmium", "glowstone_ingot", "refined_obsidian", "aquarium", "cold_iron", "star_steel", "adamantine", "marble", "limestone", "basalt", "apatite", "steeleaf", "ironwood", "knightmetal", "fiery_ingot", "meteoric_iron", "desh", "black_quartz", "vinteum", "chimerite", "blue_topaz", "moonstone", "sunstone", "aquamarine", "starmetal", "rock_crystal", "ender_biotite", "slate", "ender_amethyst", "draconium", "yellorium", "certus_quartz", "fluix", "quartz_enriched_iron"});
            IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
            int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            for (String cropName : crops) {
                ItemStack seeds = this.getItemStack(cropName + "_seeds");
                Block block = this.getBlock(cropName + "_crop");
                if (seeds != null) {
                    RecipeManagers.squeezerManager.addRecipe(10, seeds, Fluids.SEED_OIL.getFluid(seedAmount));
                }
                if (seeds == null || block == null) continue;
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(seeds, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0));
            }
            for (int i = 1; i <= 5; ++i) {
                ItemStack seeds = this.getItemStack("tier" + i + "_inferium_seeds");
                Block block = this.getBlock("tier" + i + "_inferium_crop");
                if (seeds != null) {
                    RecipeManagers.squeezerManager.addRecipe(10, seeds, Fluids.SEED_OIL.getFluid(seedAmount));
                }
                if (seeds == null || block == null) continue;
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(seeds, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0));
            }
        }
    }
}

