/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import com.google.common.base.Preconditions;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyGenome;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemButterflyGE
extends ItemGE
implements ISpriteRegister,
IColoredItem {
    private static final Random rand = new Random();
    public static final String NBT_AGE = "Age";
    private final EnumFlutterType type;

    public ItemButterflyGE(EnumFlutterType type) {
        super(Tabs.tabLepidopterology);
        this.type = type;
    }

    @Override
    @Nullable
    public IButterfly getIndividual(ItemStack itemstack) {
        return ButterflyManager.butterflyRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return ButterflyGenome.getSpecies(itemStack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(subItems, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        if (this.type == EnumFlutterType.COCOON) {
            for (int age = 0; age < 3; ++age) {
                for (IIndividual iIndividual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                    if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
                    ItemStack butterfly = ButterflyManager.butterflyRoot.getMemberStack(iIndividual, this.type);
                    ItemButterflyGE.setAge(butterfly, age);
                    subItems.add((Object)butterfly);
                }
            }
        } else {
            for (IIndividual iIndividual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
                subItems.add((Object)ButterflyManager.butterflyRoot.getMemberStack(iIndividual, this.type));
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.type != EnumFlutterType.BUTTERFLY) {
            return false;
        }
        if (entityItem.field_70170_p.field_72995_K || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (rand.nextInt(24) != 0) {
            return false;
        }
        IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(entityItem.func_92059_d());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v)) {
            return false;
        }
        if (entityItem.field_70170_p.func_72907_a(EntityButterfly.class) > ModuleLepidopterology.entityConstraint) {
            return false;
        }
        EntityUtil.spawnEntity(entityItem.field_70170_p, new EntityButterfly(entityItem.field_70170_p, butterfly, entityItem.func_180425_c()), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v);
        if (!entityItem.func_92059_d().func_190926_b()) {
            entityItem.func_92059_d().func_190918_g(1);
        } else {
            entityItem.func_70106_y();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        switch (this.type) {
            case CATERPILLAR: {
                manager.registerItemModel(item, 0, "caterpillar");
                break;
            }
            case BUTTERFLY: {
                manager.registerItemModel(item, 0, "butterflyGE");
                break;
            }
            case COCOON: {
                manager.registerItemModel(item, new CocoonMeshDefinition());
                for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                    if (!(allele instanceof IAlleleButterflyCocoon)) continue;
                    for (int age = 0; age < 3; ++age) {
                        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{((IAlleleButterflyCocoon)allele).getCocoonItemModel(age)});
                    }
                }
                break;
            }
            default: {
                manager.registerItemModel(item, 0, "liquids/jar");
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IButterfly flutter = ButterflyManager.butterflyRoot.getMember(stack);
        IBlockState blockState = world.func_180495_p(pos);
        if (this.type == EnumFlutterType.COCOON) {
            if ((pos = ButterflyManager.butterflyRoot.plantCocoon(world, pos, flutter, player.func_146103_bH(), ItemButterflyGE.getAge(stack), true)) != BlockPos.field_177992_a) {
                PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, world.func_180495_p(pos));
                NetworkUtil.sendNetworkPacket(packet, pos, world);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (this.type == EnumFlutterType.CATERPILLAR) {
            IButterflyNursery nursery = GeneticsUtil.getOrCreateNursery(player.func_146103_bH(), world, pos, true);
            if (nursery != null) {
                if (!nursery.canNurse(flutter)) {
                    return EnumActionResult.PASS;
                }
                nursery.setCaterpillar(flutter);
                PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
                NetworkUtil.sendNetworkPacket(packet, pos, world);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public static void setAge(ItemStack cocoon, int age) {
        if (cocoon.func_190926_b()) {
            return;
        }
        if (ButterflyManager.butterflyRoot.getType(cocoon) != EnumFlutterType.COCOON) {
            return;
        }
        NBTTagCompound tagCompound = cocoon.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            cocoon.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a(NBT_AGE, age);
    }

    public static int getAge(ItemStack cocoon) {
        if (cocoon.func_190926_b()) {
            return 0;
        }
        if (ButterflyManager.butterflyRoot.getType(cocoon) != EnumFlutterType.COCOON) {
            return 0;
        }
        NBTTagCompound tagCompound = cocoon.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        return tagCompound.func_74762_e(NBT_AGE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles(EnumButterflyChromosome.SPECIES)) {
            if (!(allele instanceof IAlleleButterflySpecies)) continue;
            ((IAlleleButterflySpecies)allele).registerSprites();
        }
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return super.func_77653_i(itemstack);
        }
        IButterfly individual = ButterflyManager.butterflyRoot.getMember(itemstack);
        String customKey = "for.butterflies.custom." + this.type.getName() + "." + individual.getGenome().getPrimary().getUnlocalizedName().replace("butterflies.species.", "");
        if (Translator.canTranslateToLocal(customKey)) {
            return Translator.translateToLocal(customKey);
        }
        String grammar = Translator.translateToLocal("for.butterflies.grammar." + this.type.getName());
        String speciesString = individual.getDisplayName();
        String typeString = Translator.translateToLocal("for.butterflies.grammar." + this.type.getName() + ".type");
        return grammar.replaceAll("%SPECIES", speciesString).replaceAll("%TYPE", typeString);
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        IIndividual individual;
        if (stack.func_77978_p() != null && (individual = AlleleManager.alleleRegistry.getIndividual(stack)) != null) {
            IAlleleSpecies species = individual.getGenome().getPrimary();
            return species.getSpriteColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    private static class CocoonMeshDefinition
    implements ItemMeshDefinition {
        private CocoonMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack itemstack) {
            int age;
            IButterflyGenome genome;
            NBTTagCompound tagCompound = itemstack.func_77978_p();
            if (tagCompound == null) {
                genome = ButterflyDefinition.CabbageWhite.getGenome();
                age = 0;
            } else {
                if (!tagCompound.func_74764_b(ItemButterflyGE.NBT_AGE)) {
                    tagCompound.func_74768_a(ItemButterflyGE.NBT_AGE, 0);
                }
                age = tagCompound.func_74762_e(ItemButterflyGE.NBT_AGE);
                IIndividual individual = AlleleManager.alleleRegistry.getIndividual(itemstack);
                Preconditions.checkNotNull((Object)individual);
                genome = (IButterflyGenome)individual.getGenome();
            }
            return genome.getCocoon().getCocoonItemModel(age);
        }
    }
}

