/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.world;

import forestry.core.utils.World2ObjectMap;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockManager;
import forestry.greenhouse.api.greenhouse.IGreenhouseChunk;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.blank.BlankBlockHandler;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseChunk;
import forestry.greenhouse.multiblock.blocks.wall.WallBlockHandler;
import forestry.greenhouse.multiblock.blocks.world.ChunkManager;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class GreenhouseBlockManager
implements IGreenhouseBlockManager {
    private static final GreenhouseBlockManager INSTANCE = new GreenhouseBlockManager();
    private static Thread thread;
    private static Thread clientThread;
    private World2ObjectMap<ChunkManager> managers = new World2ObjectMap(world -> new ChunkManager(world));

    private GreenhouseBlockManager() {
    }

    public static GreenhouseBlockManager getInstance() {
        return INSTANCE;
    }

    public static void setThread(Thread thread, boolean isClient) {
        if (isClient) {
            clientThread = thread;
        } else {
            GreenhouseBlockManager.thread = thread;
        }
    }

    public static Thread getClientThread() {
        return clientThread;
    }

    public static Thread getThread() {
        return thread;
    }

    public BlankBlockHandler getBlankBlockHandler() {
        return BlankBlockHandler.getInstance();
    }

    public WallBlockHandler getWallBlockHandler() {
        return WallBlockHandler.getInstance();
    }

    @Override
    @Nullable
    public IGreenhouseBlock getBlock(World world, BlockPos pos) {
        IGreenhouseChunk chunk = this.getChunk(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk != null) {
            return chunk.get(pos);
        }
        return null;
    }

    @Override
    @Nullable
    public GreenhouseChunk getChunk(World world, long pos) {
        ChunkManager manager = this.managers.get(world);
        if (manager == null) {
            return null;
        }
        return manager.getChunk(pos);
    }

    @Override
    public IGreenhouseChunk getOrCreateChunk(World world, long chunkPos) {
        ChunkManager manager = this.managers.get(world);
        if (manager == null) {
            return null;
        }
        return manager.getOrCreateChunk(chunkPos);
    }

    @Override
    @Nullable
    public GreenhouseChunk createChunk(World world, long pos) {
        ChunkManager manager = this.managers.get(world);
        if (manager == null) {
            return null;
        }
        return manager.createChunk(pos);
    }

    @Override
    @Nullable
    public void markChunkDirty(World world, long pos) {
        ChunkManager manager = this.managers.get(world);
        if (manager != null) {
            manager.markChunkDirty(pos);
        }
    }

    @Override
    @Nullable
    public synchronized List<Long> getDirtyChunks(World world) {
        ChunkManager manager = this.managers.get(world);
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.getDirtyChunks();
    }

    @Override
    @Nullable
    public synchronized void markBlockDirty(World world, BlockPos pos) {
        IGreenhouseBlock block;
        long position = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        GreenhouseChunk chunk = this.getChunk(world, position);
        if (chunk != null && (block = chunk.get(pos)) != null) {
            IGreenhouseProvider provider = block.getProvider();
            provider.onBlockChange();
        }
    }

    @Override
    @Nullable
    public synchronized void markProviderDirty(World world, BlockPos pos, IGreenhouseProvider provider) {
        long position;
        GreenhouseChunk chunk;
        if (provider != null && (chunk = this.getChunk(world, position = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)))) != null) {
            this.markChunkDirty(world, position);
            chunk.markProviderDirty(provider);
        }
    }

    @Nullable
    public void unloadChunk(World world, int x, int z) {
        ChunkManager manager = this.managers.get(world);
        if (manager != null) {
            manager.unload(x, z);
        }
    }

    @Nullable
    public void loadChunk(World world, int x, int z) {
        ChunkManager manager = this.managers.get(world);
        if (manager != null) {
            manager.load(x, z);
        }
    }

    public void scheduleUpdate(World world, BlockPos pos, IGreenhouseProvider provider, int delay) {
        ChunkManager manager = this.managers.get(world);
        if (manager != null) {
            manager.scheduleUpdate(pos, provider, delay);
        }
    }

    public void tickUpdates(World world) {
        ChunkManager manager = this.managers.get(world);
        if (manager != null) {
            manager.tickUpdates();
        }
    }
}

