/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.models;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumFarmBlockTexture {
    BRICK_STONE(new ItemStack(Blocks.field_150417_aV, 1, 0), TextFormatting.DARK_GRAY),
    BRICK_MOSSY(new ItemStack(Blocks.field_150417_aV, 1, 1), TextFormatting.DARK_GRAY),
    BRICK_CRACKED(new ItemStack(Blocks.field_150417_aV, 1, 2), TextFormatting.DARK_GRAY),
    BRICK(new ItemStack(Blocks.field_150336_V), TextFormatting.GOLD),
    SANDSTONE_SMOOTH(new ItemStack(Blocks.field_150322_A, 1, 2), TextFormatting.YELLOW),
    SANDSTONE_CHISELED(new ItemStack(Blocks.field_150322_A, 1, 1), TextFormatting.YELLOW),
    BRICK_NETHER(new ItemStack(Blocks.field_150385_bj), TextFormatting.DARK_RED),
    BRICK_CHISELED(new ItemStack(Blocks.field_150417_aV, 1, 3), TextFormatting.GOLD),
    QUARTZ(new ItemStack(Blocks.field_150371_ca, 1, 0), TextFormatting.WHITE),
    QUARTZ_CHISELED(new ItemStack(Blocks.field_150371_ca, 1, 1), TextFormatting.WHITE),
    QUARTZ_LINES(new ItemStack(Blocks.field_150371_ca, 1, 2), TextFormatting.WHITE);

    private final ItemStack base;
    private final TextFormatting formatting;

    private EnumFarmBlockTexture(ItemStack base, TextFormatting formatting) {
        this.base = base;
        this.formatting = formatting;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(EnumFarmBlockTexture texture, int side) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        switch (texture) {
            case BRICK: {
                return map.func_110572_b("minecraft:blocks/brick");
            }
            case BRICK_STONE: {
                return map.func_110572_b("minecraft:blocks/stonebrick");
            }
            case BRICK_CHISELED: {
                return map.func_110572_b("minecraft:blocks/stonebrick_carved");
            }
            case BRICK_CRACKED: {
                return map.func_110572_b("minecraft:blocks/stonebrick_cracked");
            }
            case BRICK_MOSSY: {
                return map.func_110572_b("minecraft:blocks/stonebrick_mossy");
            }
            case BRICK_NETHER: {
                return map.func_110572_b("minecraft:blocks/nether_brick");
            }
            case SANDSTONE_CHISELED: {
                if (side == 0) {
                    return map.func_110572_b("minecraft:blocks/sandstone_bottom");
                }
                if (side == 1) {
                    return map.func_110572_b("minecraft:blocks/sandstone_top");
                }
                return map.func_110572_b("minecraft:blocks/sandstone_carved");
            }
            case SANDSTONE_SMOOTH: {
                if (side == 0) {
                    return map.func_110572_b("minecraft:blocks/sandstone_bottom");
                }
                if (side == 1) {
                    return map.func_110572_b("minecraft:blocks/sandstone_top");
                }
                return map.func_110572_b("minecraft:blocks/sandstone_smooth");
            }
            case QUARTZ: {
                if (side == 0) {
                    return map.func_110572_b("minecraft:blocks/quartz_block_bottom");
                }
                if (side == 1) {
                    return map.func_110572_b("minecraft:blocks/quartz_block_top");
                }
                return map.func_110572_b("minecraft:blocks/quartz_block_side");
            }
            case QUARTZ_CHISELED: {
                if (side == 0 || side == 1) {
                    return map.func_110572_b("minecraft:blocks/quartz_block_chiseled_top");
                }
                return map.func_110572_b("minecraft:blocks/quartz_block_chiseled");
            }
            case QUARTZ_LINES: {
                if (side == 0 || side == 1) {
                    return map.func_110572_b("minecraft:blocks/quartz_block_lines_top");
                }
                return map.func_110572_b("minecraft:blocks/quartz_block_lines");
            }
        }
        return null;
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("FarmBlock", this.ordinal());
    }

    public String getName() {
        return this.base.func_77973_b().func_77653_i(this.base);
    }

    public String getUid() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public ItemStack getBase() {
        return this.base;
    }

    public static EnumFarmBlockTexture getFromCompound(@Nullable NBTTagCompound compound) {
        int farmBlockOrdinal;
        if (compound != null && (farmBlockOrdinal = compound.func_74762_e("FarmBlock")) < EnumFarmBlockTexture.values().length) {
            return EnumFarmBlockTexture.values()[farmBlockOrdinal];
        }
        return BRICK_STONE;
    }
}

