/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.ISoil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicSoil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class FarmLogicWatered
extends FarmLogicSoil {
    private static final FluidStack STACK_WATER = new FluidStack(FluidRegistry.WATER, 1000);
    protected NonNullList<ItemStack> produce = NonNullList.func_191196_a();

    public FarmLogicWatered(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        NonNullList<ItemStack> products = this.produce;
        this.produce = NonNullList.func_191196_a();
        return products;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        return this.maintainCrops(world, farmHousing, pos.func_177984_a(), direction, extent);
    }

    private boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        block0: for (ISoil soil : this.getSoils()) {
            BlockPos position;
            NonNullList resources = NonNullList.func_191196_a();
            resources.add((Object)soil.getResource());
            for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos, direction, i)); ++i) {
                IBlockState state = world.func_180495_p(position);
                if (this.isAcceptedSoil(state) || this.isWaterSourceBlock(world, position) || !farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) continue;
                BlockPos platformPosition = position.func_177977_b();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                if (!BlockUtil.isReplaceableBlock(state, world, position)) {
                    this.produce.addAll(BlockUtil.getBlockDrops(world, position));
                    world.func_175698_g(position);
                    return this.trySetSoil(world, farmHousing, position, soil.getResource(), soil.getSoilState());
                }
                if (this.isManual) continue;
                if (this.trySetWater(world, farmHousing, position)) {
                    return true;
                }
                return this.trySetSoil(world, farmHousing, position, soil.getResource(), soil.getSoilState());
            }
        }
        return false;
    }

    private boolean maintainWater(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos platformPosition;
        BlockPos position;
        for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos, direction, i)) && farmHousing.isValidPlatform(world, platformPosition = position.func_177977_b()); ++i) {
            if (!this.trySetWater(world, farmHousing, position)) continue;
            return true;
        }
        return false;
    }

    protected boolean maintainCrops(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(World world, IFarmHousing farmHousing, BlockPos position, ItemStack resource, IBlockState ground) {
        NonNullList resources = NonNullList.func_191196_a();
        resources.add((Object)resource);
        if (!farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) {
            return false;
        }
        if (!BlockUtil.setBlockWithPlaceSound(world, position, ground)) {
            return false;
        }
        farmHousing.getFarmInventory().removeResources((NonNullList<ItemStack>)resources);
        return true;
    }

    private boolean trySetWater(World world, IFarmHousing farmHousing, BlockPos position) {
        if (this.isWaterSourceBlock(world, position) || !this.canPlaceWater(world, position)) {
            return false;
        }
        if (!farmHousing.hasLiquid(STACK_WATER)) {
            return false;
        }
        this.produce.addAll(BlockUtil.getBlockDrops(world, position));
        BlockUtil.setBlockWithPlaceSound(world, position, Blocks.field_150355_j.func_176223_P());
        farmHousing.removeLiquid(STACK_WATER);
        return true;
    }

    private boolean canPlaceWater(World world, BlockPos position) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos offsetPosition = position.func_177982_a(x, 0, z);
                if (!this.isWaterSourceBlock(world, offsetPosition)) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            BlockPos offsetPosition = position.func_177982_a(x, 0, 0);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        for (int z = -1; z <= 1; ++z) {
            BlockPos offsetPosition = position.func_177982_a(0, 0, z);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        return true;
    }
}

