/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmRegistry;
import forestry.api.farming.IFarmable;
import forestry.api.farming.ISimpleFarmLogic;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.farming.logic.FakeFarmProperties;
import forestry.farming.logic.FarmLogicSimple;
import forestry.farming.logic.FarmProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;

public final class FarmRegistry
implements IFarmRegistry {
    private static final FarmRegistry INSTANCE = new FarmRegistry();
    private final Multimap<String, IFarmable> farmables = HashMultimap.create();
    private final Map<ItemStack, Integer> fertilizers = new LinkedHashMap<ItemStack, Integer>();
    private final Map<String, IFarmProperties> farmInstances = new HashMap<String, IFarmProperties>();
    private FertilizerConfig fertilizer = FertilizerConfig.access$000();

    public static FarmRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    @Deprecated
    public void registerLogic(String identifier, IFarmLogic logic) {
    }

    @Override
    public void registerFarmables(String identifier, IFarmable ... farmablesArray) {
        this.farmables.putAll((Object)identifier, Arrays.asList(farmablesArray));
    }

    @Override
    public Collection<IFarmable> getFarmables(String identifier) {
        return this.farmables.get((Object)identifier);
    }

    @Override
    public IFarmLogic createCropLogic(IFarmProperties instance, boolean isManual, ISimpleFarmLogic simpleFarmLogic) {
        return new FarmLogicSimple(instance, isManual, simpleFarmLogic);
    }

    @Override
    public IFarmProperties createFakeInstance(IFarmLogic logic) {
        return new FakeFarmProperties(logic);
    }

    @Override
    public void registerFertilizer(ItemStack itemStack, int value) {
        if (itemStack.func_190926_b()) {
            return;
        }
        this.fertilizers.put(itemStack, value);
    }

    @Override
    public int getFertilizeValue(ItemStack itemStack) {
        return this.fertilizer.getFertilizeValue(itemStack);
    }

    @Override
    public IFarmProperties registerLogic(String identifier, IFarmProperties farmInstance) {
        this.farmInstances.put(identifier, farmInstance);
        return farmInstance;
    }

    @Override
    public IFarmProperties registerLogic(String identifier, BiFunction<IFarmProperties, Boolean, IFarmLogic> logicFactory, String ... farmablesIdentifiers) {
        HashSet<String> identifiers = new HashSet<String>(Arrays.asList(farmablesIdentifiers));
        identifiers.add(identifier);
        FarmProperties instance = new FarmProperties(logicFactory, identifiers);
        this.farmInstances.put(identifier, instance);
        return instance;
    }

    @Override
    @Nullable
    public IFarmProperties getProperties(String identifier) {
        return this.farmInstances.get(identifier);
    }

    void loadConfig(LocalizedConfiguration config) {
        Map<String, String> defaultEntries = this.getItemStrings();
        ArrayList<String> defaultFertilizers = new ArrayList<String>(defaultEntries.values());
        Collections.sort(defaultFertilizers);
        String[] defaultSortedFertilizers = defaultFertilizers.toArray(new String[defaultFertilizers.size()]);
        Property property = config.get("fertilizers", "items", defaultSortedFertilizers, Translator.translateToLocal("for.config.farm.fertilizers.items"));
        ImmutableMap<ItemStack, Integer> fertilizerMap = this.checkConfig(property, defaultEntries);
        this.fertilizer = new FertilizerConfig((Map)fertilizerMap);
    }

    private ImmutableMap<ItemStack, Integer> checkConfig(Property property, Map<String, String> defaultEntries) {
        String[] fertilizerList = property.getStringList();
        ImmutableMap.Builder fertilizerMap = new ImmutableMap.Builder();
        Map<String, String> configEntries = this.parseConfig(fertilizerList, (ImmutableMap.Builder<ItemStack, Integer>)fertilizerMap);
        ArrayList<String> newEntries = new ArrayList<String>(Arrays.asList(fertilizerList));
        for (Map.Entry<String, String> defaultEntry : defaultEntries.entrySet()) {
            if (configEntries.containsKey(defaultEntry.getKey())) continue;
            newEntries.add(defaultEntry.getValue());
        }
        if (newEntries.size() > fertilizerList.length) {
            Collections.sort(newEntries);
            property.set(newEntries.toArray(new String[newEntries.size()]));
            return this.checkConfig(property, defaultEntries);
        }
        return fertilizerMap.build();
    }

    private Map<String, String> parseConfig(String[] fertilizerList, ImmutableMap.Builder<ItemStack, Integer> fertilizerMap) {
        HashMap<String, String> configEntries = new HashMap<String, String>();
        for (String entry : fertilizerList) {
            String[] spited = entry.split(";");
            if (spited.length < 2) {
                Log.error("Forestry failed to parse a entry of the fertilizer config.", new Object[0]);
                continue;
            }
            String itemName = spited[0];
            ItemStack fertilizerItem = ItemStackUtil.parseItemStackString(itemName, Short.MAX_VALUE);
            if (fertilizerItem == null || fertilizerItem.func_190926_b()) {
                Log.error("Forestry failed to parse a entry of the fertilizer config, because the item doesn't exists.", new Object[0]);
                continue;
            }
            String value = spited[1];
            int fertilizerValue = Integer.parseInt(value);
            if (fertilizerValue > 0) {
                fertilizerMap.put((Object)fertilizerItem, (Object)fertilizerValue);
            }
            configEntries.put(itemName, value);
        }
        return configEntries;
    }

    private Map<String, String> getItemStrings() {
        HashMap<String, String> itemStrings = new HashMap<String, String>(this.fertilizers.size());
        for (Map.Entry<ItemStack, Integer> itemStack : this.fertilizers.entrySet()) {
            String itemString = ItemStackUtil.getStringForItemStack(itemStack.getKey());
            itemStrings.put(itemString, itemString + ";" + itemStack.getValue());
        }
        return itemStrings;
    }

    private static class FertilizerConfig {
        private static final FertilizerConfig DUMMY = new FertilizerConfig(Collections.emptyMap());
        private final Map<ItemStack, Integer> fertilizers;

        private FertilizerConfig(Map<ItemStack, Integer> fertilizers) {
            this.fertilizers = fertilizers;
        }

        private int getFertilizeValue(ItemStack itemStack) {
            for (Map.Entry<ItemStack, Integer> fertilizer : this.fertilizers.entrySet()) {
                ItemStack fertilizerStack = fertilizer.getKey();
                if (!ItemStackUtil.isIdenticalItem(fertilizerStack, itemStack)) continue;
                return fertilizer.getValue();
            }
            return 0;
        }

        static /* synthetic */ FertilizerConfig access$000() {
            return DUMMY;
        }
    }
}

