/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.tiles;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmInventory;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.VectUtil;
import forestry.cultivation.gui.ContainerPlanter;
import forestry.cultivation.gui.GuiPlanter;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.farming.FarmHelper;
import forestry.farming.FarmRegistry;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.multiblock.FarmFertilizerManager;
import forestry.farming.multiblock.FarmHydrationManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TilePlanter
extends TilePowered
implements IFarmHousing,
IClimatised,
ILiquidTankTile,
IOwnedTile,
IStreamableGui {
    private final Map<FarmDirection, List<FarmTarget>> targets = new EnumMap<FarmDirection, List<FarmTarget>>(FarmDirection.class);
    private final Stack<ItemStack> pendingProduce = new Stack();
    private final List<ICrop> pendingCrops = new LinkedList<ICrop>();
    private final String identifier;
    private final FarmHydrationManager hydrationManager;
    private final FarmFertilizerManager fertilizerManager;
    private final InventoryPlanter inventory;
    private final TankManager tankManager;
    private final StandardTank resourceTank;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private int platformHeight = -1;
    private FarmHelper.Stage stage = FarmHelper.Stage.CULTIVATE;
    private boolean isManual;
    private IFarmLogic logic;
    @Nullable
    private Vec3i offset;
    @Nullable
    private Vec3i area;

    public void setManual(boolean manual) {
        this.isManual = manual;
        this.logic = FarmRegistry.getInstance().getProperties(this.identifier).getLogic(manual);
    }

    protected TilePlanter(String identifier) {
        super(150, 1500);
        this.identifier = identifier;
        this.setManual(false);
        this.inventory = new InventoryPlanter(this);
        this.setInternalInventory(this.inventory);
        this.hydrationManager = new FarmHydrationManager(this);
        this.fertilizerManager = new FarmFertilizerManager();
        this.resourceTank = new FilteredTank(10000).setFilters(FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.setEnergyPerWorkCycle(10);
        this.setTicksPerWorkCycle(2);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.platformHeight = posIn.func_177956_o() - 2;
    }

    @Override
    public boolean hasWork() {
        return true;
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        this.hydrationManager.updateServer(this.field_145850_b, this.getCoords());
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
    }

    @Override
    protected boolean workCycle() {
        boolean hasFertilizer;
        IErrorLogic errorLogic;
        if (this.targets.isEmpty() || this.updateOnInterval(10)) {
            this.setUpFarmlandTargets();
        }
        if ((errorLogic = this.getErrorLogic()).setCondition(!(hasFertilizer = this.fertilizerManager.maintainFertilizer(this.inventory)), EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        if (!this.pendingProduce.isEmpty()) {
            boolean added = this.inventory.tryAddPendingProduce(this.pendingProduce);
            errorLogic.setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
            return added;
        }
        if (!this.pendingCrops.isEmpty()) {
            ICrop first = this.pendingCrops.get(0);
            if (this.cullCrop(first)) {
                this.pendingCrops.remove(0);
                return true;
            }
            return false;
        }
        FarmHelper.FarmWorkStatus farmWorkStatus = new FarmHelper.FarmWorkStatus();
        List<FarmDirection> farmDirections = Arrays.asList(FarmDirection.values());
        Collections.shuffle(farmDirections, this.field_145850_b.field_73012_v);
        for (FarmDirection farmSide : farmDirections) {
            IFarmLogic logic = this.getFarmLogic(farmSide);
            if (this.collectWindfall()) {
                farmWorkStatus.didWork = true;
            }
            List<FarmTarget> farmTargets = this.targets.get((Object)farmSide);
            if (this.stage == FarmHelper.Stage.HARVEST) {
                Collection<ICrop> harvested = FarmHelper.harvestTargets(this.field_145850_b, farmTargets, logic, Collections.emptySet());
                boolean bl = farmWorkStatus.didWork = !harvested.isEmpty();
                if (!harvested.isEmpty()) {
                    this.pendingCrops.addAll(harvested);
                    this.pendingCrops.sort(FarmHelper.TopDownICropComparator.INSTANCE);
                }
            } else if (this.stage == FarmHelper.Stage.CULTIVATE) {
                farmWorkStatus = this.cultivateTargets(farmWorkStatus, farmTargets, farmSide);
            }
            if (!farmWorkStatus.didWork) continue;
            break;
        }
        if (this.stage == FarmHelper.Stage.CULTIVATE) {
            errorLogic.setCondition(!farmWorkStatus.hasFarmland, EnumErrorCode.NO_FARMLAND);
            errorLogic.setCondition(!farmWorkStatus.hasFertilizer, EnumErrorCode.NO_FERTILIZER);
            errorLogic.setCondition(!farmWorkStatus.hasLiquid, EnumErrorCode.NO_LIQUID_FARM);
        }
        this.stage = this.stage.next();
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
        this.ownerHandler.writeToNBT(data);
        data.func_74757_a("isManual", this.isManual);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.hydrationManager.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.fertilizerManager.readFromNBT(data);
        this.ownerHandler.readFromNBT(data);
        this.setManual(data.func_74767_n("isManual"));
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.tankManager.writeData(data);
        this.hydrationManager.writeData(data);
        this.fertilizerManager.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.tankManager.readData(data);
        this.hydrationManager.readData(data);
        this.fertilizerManager.readData(data);
    }

    private void setUpFarmlandTargets() {
        BlockPos targetStart = this.getCoords();
        BlockPos minPos = this.field_174879_c;
        BlockPos maxPos = this.field_174879_c;
        int size = 1;
        int extend = Config.planterExtend;
        if (Config.ringFarms) {
            int ringSize = Config.ringSize;
            minPos = this.field_174879_c.func_177982_a(-ringSize, 0, -ringSize);
            maxPos = this.field_174879_c.func_177982_a(ringSize, 0, ringSize);
            size = 1 + ringSize * 2;
            --extend;
        }
        FarmHelper.createTargets(this.field_145850_b, this, this.targets, targetStart, extend, size, size, minPos, maxPos);
        FarmHelper.setExtents(this.field_145850_b, this, this.targets);
    }

    private boolean cullCrop(ICrop crop) {
        Boolean hasFertilizer;
        int fertilizerConsumption = Math.round((float)this.logic.getFertilizerConsumption() * Config.fertilizerModifier * 2.0f);
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition((hasFertilizer = Boolean.valueOf(this.fertilizerManager.hasFertilizer(this.inventory, fertilizerConsumption))) == false, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        float hydrationModifier = this.hydrationManager.getHydrationModifier();
        int waterConsumption = this.logic.getWaterConsumption(hydrationModifier);
        FluidStack requiredLiquid = new FluidStack(FluidRegistry.WATER, waterConsumption);
        boolean hasLiquid = requiredLiquid.amount == 0 || this.hasLiquid(requiredLiquid);
        if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NO_LIQUID_FARM)) {
            return false;
        }
        NonNullList<ItemStack> harvested = crop.harvest();
        if (harvested != null) {
            this.fertilizerManager.removeFertilizer(this.inventory, fertilizerConsumption);
            this.removeLiquid(requiredLiquid);
            this.inventory.stowHarvest((Iterable<ItemStack>)harvested, this.pendingProduce);
        }
        return true;
    }

    private boolean collectWindfall() {
        NonNullList<ItemStack> collected = this.logic.collect(this.field_145850_b, this);
        if (collected.isEmpty()) {
            return false;
        }
        for (ItemStack produce : collected) {
            this.inventory.addProduce(produce);
            this.pendingProduce.push(produce);
        }
        return true;
    }

    private FarmHelper.FarmWorkStatus cultivateTargets(FarmHelper.FarmWorkStatus farmWorkStatus, List<FarmTarget> farmTargets, FarmDirection farmSide) {
        boolean hasFarmland = false;
        for (FarmTarget target : farmTargets) {
            if (target.getExtent() <= 0) continue;
            hasFarmland = true;
            farmWorkStatus.hasFarmland = true;
            break;
        }
        if (hasFarmland && !FarmHelper.isCycleCanceledByListeners(this.logic, farmSide, Collections.emptySet())) {
            float hydrationModifier = this.hydrationManager.getHydrationModifier();
            int fertilizerConsumption = Math.round((float)this.logic.getFertilizerConsumption() * Config.fertilizerModifier * 2.0f);
            int liquidConsumption = this.logic.getWaterConsumption(hydrationModifier);
            FluidStack liquid = new FluidStack(FluidRegistry.WATER, liquidConsumption);
            for (FarmTarget target : farmTargets) {
                if (!this.fertilizerManager.hasFertilizer(this.inventory, fertilizerConsumption)) {
                    farmWorkStatus.hasFertilizer = false;
                    continue;
                }
                if (liquid.amount > 0 && !this.hasLiquid(liquid)) {
                    farmWorkStatus.hasLiquid = false;
                    continue;
                }
                if (!FarmHelper.cultivateTarget(this.field_145850_b, this, target, this.logic, Collections.emptySet())) continue;
                this.fertilizerManager.removeFertilizer(this.inventory, fertilizerConsumption);
                this.removeLiquid(liquid);
                farmWorkStatus.didWork = true;
            }
        }
        return farmWorkStatus;
    }

    @Override
    public BlockPos getCoords() {
        return this.field_174879_c;
    }

    @Override
    public Vec3i getArea() {
        if (this.area == null) {
            int basisArea = 5;
            if (Config.ringFarms) {
                basisArea = basisArea + 1 + Config.ringSize * 2;
            }
            this.area = new Vec3i(basisArea + Config.planterExtend, 13, basisArea + Config.planterExtend);
        }
        return this.area;
    }

    @Override
    public Vec3i getOffset() {
        if (this.offset == null) {
            Vec3i area = this.getArea();
            this.offset = new Vec3i(-area.func_177958_n() / 2, -2, -area.func_177952_p() / 2);
        }
        return this.offset;
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        FluidStack drained = this.resourceTank.drainInternal(liquid, false);
        return liquid.isFluidStackIdentical(drained);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.resourceTank.drain(liquid.amount, true);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, BlockPos pos) {
        EntityPlayer player = PlayerUtil.getFakePlayer(world, this.getOwnerHandler().getOwner());
        return player != null && this.inventory.plantGermling(germling, player, pos);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public boolean plantGermling(IFarmable farmable, World world, BlockPos pos, FarmDirection direction) {
        EntityPlayer player = PlayerUtil.getFakePlayer(world, this.getOwnerHandler().getOwner());
        return player != null && this.inventory.plantGermling(farmable, player, pos, direction);
    }

    @Override
    public boolean isValidPlatform(World world, BlockPos pos) {
        return pos.func_177956_o() == this.platformHeight;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean canPlantSoil(boolean manual) {
        return !this.isManual;
    }

    @Override
    public IFarmInventory getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void setFarmLogic(FarmDirection direction, IFarmLogic logic) {
    }

    @Override
    public void resetFarmLogic(FarmDirection direction) {
    }

    @Override
    public IFarmLogic getFarmLogic(FarmDirection direction) {
        return this.getFarmLogic();
    }

    public IFarmLogic getFarmLogic() {
        return this.logic;
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.fertilizerManager.getStoredFertilizerScaled(this.inventory, scale);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.targets.clear();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189517_E_();
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
        return data;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vec3i)pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiPlanter(this, player.field_71071_by);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerPlanter(this, player.field_71071_by);
    }

    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.hydrationManager;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getCoordinates();
        return ClimateUtil.getTemperature(this.getWorldObj(), coords);
    }

    @Override
    public float getExactHumidity() {
        BlockPos coords = this.getCoordinates();
        return ClimateUtil.getHumidity(this.getWorldObj(), coords);
    }

    @Override
    public ITankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getTankManager());
        }
        return super.getCapability(capability, facing);
    }

    protected NonNullList<ItemStack> createList(ItemStack ... stacks) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public abstract NonNullList<ItemStack> createGermlingStacks();

    public abstract NonNullList<ItemStack> createResourceStacks();

    public abstract NonNullList<ItemStack> createProductionStacks();
}

