/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.core.IToolScoop;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForestryLeaves
extends BlockAbstractLeaves
implements ITileEntityProvider,
IGrowable {
    public BlockForestryLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176237_a, field_176236_b}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    @Override
    protected ITree getTree(IBlockAccess world, BlockPos pos) {
        ITree tree;
        TileLeaves leaves = TileUtil.getTile(world, pos, TileLeaves.class);
        if (leaves != null && (tree = leaves.getTree()) != null) {
            return tree;
        }
        return null;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        TileLeaves tileLeaves = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (tileLeaves != null && !tileLeaves.func_145837_r() && (double)rand.nextFloat() <= 0.1) {
            tileLeaves.onBlockTick(world, pos, state, rand);
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLeaves();
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune) {
        TileLeaves tile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (tile == null) {
            return;
        }
        ITree tree = tile.getTree();
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getMemberStack(sapling, EnumGermlingType.SAPLING));
        }
        if (tile.hasFruit()) {
            drops.addAll(tree.produceStacks(world, pos, tile.getRipeningTime()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:leaves", "inventory"));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileLeaves leaves = TileUtil.getTile((IBlockAccess)worldIn, pos, TileLeaves.class);
        if (leaves != null) {
            IButterfly caterpillar = leaves.getCaterpillar();
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
                ItemStack butterfly = ButterflyManager.butterflyRoot.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR);
                ItemStackUtil.dropItemStackAsEntity(butterfly, worldIn, pos);
                leaves.setCaterpillar(null);
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        TileLeaves leafTile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        return leafTile != null && leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileLeaves leafTile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (leafTile != null) {
            leafTile.addRipeness(0.5f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        TileLeaves leaves;
        if (worldIn != null && pos != null && (leaves = TileUtil.getTile(worldIn, pos, TileLeaves.class)) != null) {
            if (tintIndex == 2) {
                return leaves.getFruitColour();
            }
            EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
            return leaves.getFoliageColour((EntityPlayer)thePlayer);
        }
        return ModuleArboriculture.proxy.getFoliageColorBasic();
    }
}

