/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.blocks;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidUtil;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.gui.GuiHandler;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.ModuleGreenhouse;
import forestry.greenhouse.models.ModelCamouflaged;
import forestry.greenhouse.tiles.TileDehumidifier;
import forestry.greenhouse.tiles.TileFan;
import forestry.greenhouse.tiles.TileHeater;
import forestry.greenhouse.tiles.TileHumidifier;
import forestry.greenhouse.tiles.TileHygroregulator;

public class BlockClimatiser extends Block implements IBlockWithMeta, ISpriteRegister, IItemModelRegister, IColoredBlock, IBlockCamouflaged<BlockClimatiser>, ITileEntityProvider {
	public static final PropertyEnum<BlockClimatiserType> TYPE = PropertyEnum.func_177709_a("type", BlockClimatiserType.class);

	public BlockClimatiser() {
		super(Material.field_151592_s);

		func_149711_c(1.0f);
		setHarvestLevel("pickaxe", 0);
		func_149647_a(ModuleGreenhouse.getGreenhouseTab());
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, BlockClimatiserType.HUMIDIFIER));
	}

	@Override
	public String getNameFromMeta(int meta) {
		BlockClimatiserType type = BlockClimatiserType.VALUES[meta];
		return type.func_176610_l();
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(TYPE, BlockClimatiserType.VALUES[meta]);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(TYPE).ordinal();
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_176221_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
		IActivatable tile = TileUtil.getTile(worldIn, pos, IActivatable.class);
		State state = State.OFF;
		if (tile != null) {
			state = tile.isActive() ? State.ON : State.OFF;
		}
		return super.func_176221_a(blockState, worldIn, pos).func_177226_a(State.PROPERTY, state);
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	/* MODELS */
	@Override
	@SideOnly(Side.CLIENT)
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.SOLID;
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		TileForestry tile = TileUtil.getTile(world, pos, TileForestry.class);
		if (tile != null) {
			if (TileUtil.isUsableByPlayer(player, tile)) {

				if (!player.func_70093_af()) {
					if (FluidUtil.interactWithFluidHandler(player, hand, world, pos, facing)) {
						return true;
					}
				}

				if (!world.field_72995_K) {
					GuiHandler.openGui(player, tile);
				}
				return true;
			}
		}
		return false;
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (int i = 0; i < BlockClimatiserType.VALUES.length; i++) {
			list.add(new ItemStack(this, 1, i));
		}
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new ExtendedBlockState(this, new IProperty[]{TYPE, State.PROPERTY}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
		if (GuiScreen.func_146272_n()) {
			tooltip.add(TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString() + Translator.translateToLocal("tile.for.greenhouse.camouflage.tooltip"));
		} else {
			ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
		}
	}

	@Override
	public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
		return ((IExtendedBlockState) super.getExtendedState(state, world, pos)).withProperty(UnlistedBlockPos.POS, pos).withProperty(UnlistedBlockAccess.BLOCKACCESS, world);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
		return true;
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		BlockClimatiserType type = BlockClimatiserType.VALUES[meta];
		switch (type) {
			case DEHUMIDIFIER:
				return new TileDehumidifier();
			case HUMIDIFIER:
				return new TileHumidifier();
			case HYGRO:
				return new TileHygroregulator();
			case FAN:
				return new TileFan();
			case HEATER:
				return new TileHeater();
		}
		return null;
	}

	@Override
	@SideOnly(Side.CLIENT)
	@SuppressWarnings("deprecation")
	public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
		if (pos == null || worldIn == null) {
			return 0xffffff;
		}
		ItemStack camouflageStack = getCamouflageBlock(worldIn, pos);

		if (tintIndex < ModelCamouflaged.OVERLAY_COLOR_INDEX && !camouflageStack.func_190926_b()) {
			Block block = Block.func_149634_a(camouflageStack.func_77973_b());
			if (block != Blocks.field_150350_a) {
				IBlockState camouflageState = block.func_176203_a(camouflageStack.func_77952_i());
				BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();

				int color = blockColors.func_186724_a(camouflageState, worldIn, pos, tintIndex);
				if (color != -1) {
					return color;
				}
			}
		}

		return 0xffffff;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < BlockClimatiserType.VALUES.length; i++) {
			ModelLoader.setCustomModelResourceLocation(item, i, new ModelResourceLocation("forestry:climatiser", "inventory"));
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerSprites(ITextureManager manager) {
		BlockClimatiserSprite.registerSprites();
	}

	@Override
	public ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
		if (world == null || pos == null) {
			return ItemStack.field_190927_a;
		}
		ICamouflageHandler handler = getCamouflageHandler(world, pos);
		if (handler != null) {
			ItemStack camouflageStack = handler.getCamouflageBlock();
			ItemStack defaultCamouflageStack = handler.getDefaultCamouflageBlock();
			if (!ItemStackUtil.isIdenticalItem(camouflageStack, defaultCamouflageStack)) {
				return camouflageStack;
			}
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
		if (world == null || pos == null) {
			return null;
		}
		ICamouflageHandler handler = TileUtil.getTile(world, pos, ICamouflageHandler.class);
		if (handler != null) {
			return handler;
		}
		return null;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean hasOverlaySprite(int meta, int layer) {
		return true;
	}

	@Override
	public int getLayers() {
		return 1;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public TextureAtlasSprite getDefaultSprite() {
		return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.PLAIN, null, null, -1);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public TextureAtlasSprite getOverlaySprite(EnumFacing facing, IBlockState state, int meta, int layer) {
		return BlockClimatiserSprite.getSprite(BlockClimatiserType.VALUES[meta], facing, state);
	}
}
