/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui.widgets;

import forestry.api.genetics.EnumDatabaseTab;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.database.gui.widgets.WidgetDatabaseScreen;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class WidgetDatabaseTabs
extends Widget {
    private static final ResourceLocation CREATIVE_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final EnumDatabaseTab[] TABS = EnumDatabaseTab.values();
    private static final Drawable GUI_TAB = new Drawable(CREATIVE_TEXTURE, 0, 64, 28, 28);
    private static final Drawable GUI_TAB_ACTIVE_LEFT = new Drawable(CREATIVE_TEXTURE, 0, 96, 28, 32);
    private static final Drawable GUI_TAB_ACTIVE_CENTER = new Drawable(CREATIVE_TEXTURE, 28, 96, 28, 32);
    private static final Drawable GUI_TAB_ACTIVE_RIGHT = new Drawable(CREATIVE_TEXTURE, 140, 96, 28, 32);
    private final WidgetDatabaseScreen parent;
    public int spacing = 2;
    public int selectedTab;

    public WidgetDatabaseTabs(WidgetManager manager, int xPos, int yPos, WidgetDatabaseScreen parent) {
        super(manager, xPos, yPos);
        this.width = 28;
        this.height = 28;
        this.parent = parent;
        this.parent.setTabs(this);
        this.selectedTab = 0;
    }

    @Override
    public void draw(int startX, int startY) {
    }

    public void drawTabs(int startX, int startY) {
        for (int tabIndex = 0; tabIndex < TABS.length; ++tabIndex) {
            if (tabIndex == this.selectedTab) continue;
            EnumDatabaseTab tab = TABS[tabIndex];
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Drawable tabTexture = GUI_TAB;
            int xPos = this.xPos + tabIndex * (WidgetDatabaseTabs.GUI_TAB.width + this.spacing);
            tabTexture.draw(xPos, this.yPos - 4);
            GuiUtil.drawItemStack(this.manager.gui, this.parent.getItemStack(tab), startX + xPos + 6, startY + this.yPos + 2);
        }
    }

    public void drawSelectedTab(int startX, int startY) {
        int textureIndex;
        if (this.selectedTab < 0) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnumDatabaseTab tab = TABS[this.selectedTab];
        int n = this.selectedTab == 0 ? 0 : (textureIndex = this.selectedTab == TABS.length - 1 ? 2 : 1);
        Drawable tabTexture = textureIndex == 0 ? GUI_TAB_ACTIVE_LEFT : (textureIndex == 2 ? GUI_TAB_ACTIVE_RIGHT : GUI_TAB_ACTIVE_CENTER);
        int xPos = this.xPos + this.selectedTab * (WidgetDatabaseTabs.GUI_TAB.width + this.spacing);
        tabTexture.draw(xPos, this.yPos - 4);
        GuiUtil.drawItemStack(this.manager.gui, this.parent.getItemStack(tab), startX + xPos + 6, startY + this.yPos + 2);
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        GuiForestry gui = this.manager.gui;
        int mouseOverTab = this.getMouseOverTab(mouseX -= gui.getGuiLeft(), mouseY -= gui.getGuiTop());
        if (mouseOverTab < 0) {
            return;
        }
        if (this.selectedTab != mouseOverTab) {
            this.selectedTab = this.parent.onTabChange(TABS[mouseOverTab]);
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        int mouseOverTab = this.getMouseOverTab(mouseX, mouseY);
        return mouseOverTab >= 0;
    }

    @Nullable
    public int getMouseOverTab(int mouseX, int mouseY) {
        mouseX -= this.xPos;
        if ((mouseY -= this.yPos) < 0 || mouseY > this.height) {
            return -1;
        }
        int x = 0;
        for (int tabIndex = 0; tabIndex < TABS.length; ++tabIndex) {
            if (mouseX < x || mouseX > x + WidgetDatabaseTabs.GUI_TAB.width) {
                x += this.spacing + WidgetDatabaseTabs.GUI_TAB.width;
                continue;
            }
            return tabIndex;
        }
        return -1;
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        int mouseOverTab = this.getMouseOverTab(mouseX, mouseY);
        if (mouseOverTab < 0) {
            return null;
        }
        EnumDatabaseTab tab = TABS[mouseOverTab];
        ToolTip toolTip = new ToolTip();
        toolTip.add(this.parent.getTooltip(tab));
        return toolTip;
    }
}

