/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementLayout;
import forestry.core.gui.elements.GuiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class GuiElementLayout
extends GuiElement
implements IGuiElementLayout {
    protected final List<IGuiElement> elements = new ArrayList<IGuiElement>();
    protected final List<String> tooltip = new ArrayList<String>();
    public int distance;

    public GuiElementLayout(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    @Override
    public GuiElementLayout setDistance(int distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public void addTooltip(String line) {
        this.tooltip.add(line);
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public List<IGuiElement> getElements() {
        return this.elements;
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public void draw(int startX, int startY) {
        this.elements.forEach(element -> element.draw(startX + this.getX(), startY + this.getY()));
    }

    @Override
    public List<String> getToolTip(int mouseX, int mouseY) {
        mouseX -= this.getX();
        mouseY -= this.getY();
        for (IGuiElement element : this.elements) {
            List<String> toolTip;
            if (!element.isMouseOver(mouseX, mouseY) || (toolTip = element.getToolTip(mouseX, mouseY)).isEmpty()) continue;
            return toolTip;
        }
        if (!this.tooltip.isEmpty()) {
            return this.tooltip;
        }
        return Collections.emptyList();
    }
}

